/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.text;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import org.jfree.fonts.tools.ByteTable;
import org.jfree.util.Log;

public final class GraphemeClassifier {
    public static final int OTHER = 0;
    public static final int CR = 1;
    public static final int LF = 2;
    public static final int CONTROL = 3;
    public static final int EXTEND = 4;
    public static final int L = 8;
    public static final int LV = 24;
    public static final int V = 56;
    public static final int T = 104;
    public static final int LVT = 72;
    public static final int ANY_HANGUL_MASK = 8;
    public static final int V_OR_LV_MASK = 24;
    public static final int V_OR_T_MASK = 40;
    public static final int LVT_OR_T_MASK = 72;
    private ByteTable classificationData;
    private static GraphemeClassifier classifier;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GraphemeClassifier() {
        InputStream in = this.getClass().getResourceAsStream("/org/jfree/fonts/text/generated/grapheme-classification.ser");
        if (in != null) {
            try {
                ObjectInputStream oin = new ObjectInputStream(in);
                this.classificationData = (ByteTable)oin.readObject();
                oin.close();
                in = null;
            }
            catch (Exception e) {
                Log.warn((Object)"Unable to load the pre-generated classification data.", (Exception)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public int getGraphemeClassification(int codePoint) {
        if (this.classificationData != null) {
            int row = codePoint >> 8;
            int col = codePoint & 0xFF;
            return this.classificationData.getByte(row, col, (byte)0);
        }
        if (codePoint == 13) {
            return 1;
        }
        if (codePoint == 10) {
            return 2;
        }
        return 0;
    }

    public static synchronized GraphemeClassifier getClassifier() {
        if (classifier == null) {
            classifier = new GraphemeClassifier();
        }
        return classifier;
    }
}

