/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.text.font;

import org.jfree.fonts.registry.FontMetrics;
import org.jfree.fonts.text.font.FontSizeProducer;
import org.jfree.fonts.text.font.GlyphMetrics;
import org.jfree.fonts.tools.StrictGeomUtility;

public class StaticFontSizeProducer
implements FontSizeProducer {
    private int maxWidth;
    private int maxHeight;
    private int baseLine;

    public StaticFontSizeProducer(FontMetrics fontMetrics) {
        if (fontMetrics == null) {
            throw new NullPointerException();
        }
        this.maxHeight = (int)(Integer.MAX_VALUE & StrictGeomUtility.toInternalValue(fontMetrics.getMaxHeight()));
        this.maxWidth = (int)(Integer.MAX_VALUE & StrictGeomUtility.toInternalValue(fontMetrics.getMaxCharAdvance()));
        this.baseLine = (int)(Integer.MAX_VALUE & StrictGeomUtility.toInternalValue(fontMetrics.getMaxHeight() - fontMetrics.getMaxDescent()));
    }

    public StaticFontSizeProducer(int maxWidth, int maxHeight, int baseLine) {
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.baseLine = baseLine;
    }

    public GlyphMetrics getCharacterSize(int codePoint, GlyphMetrics dimension) {
        if (dimension == null) {
            GlyphMetrics retval = new GlyphMetrics();
            retval.setWidth(this.maxWidth);
            retval.setHeight(this.maxHeight);
            retval.setBaselinePosition(this.baseLine);
            return retval;
        }
        dimension.setWidth(this.maxWidth);
        dimension.setHeight(this.maxHeight);
        dimension.setBaselinePosition(this.baseLine);
        return dimension;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

