/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.text.font;

import org.jfree.fonts.registry.FontMetrics;
import org.jfree.fonts.text.font.FontSizeProducer;
import org.jfree.fonts.text.font.GlyphMetrics;
import org.jfree.fonts.tools.StrictGeomUtility;

public class VariableFontSizeProducer
implements FontSizeProducer {
    private FontMetrics fontMetrics;
    private int maxHeight;
    private int baseLine;

    public VariableFontSizeProducer(FontMetrics fontMetrics) {
        if (fontMetrics == null) {
            throw new NullPointerException();
        }
        this.fontMetrics = fontMetrics;
        this.maxHeight = (int)(Integer.MAX_VALUE & StrictGeomUtility.toInternalValue(fontMetrics.getMaxHeight()));
        this.baseLine = (int)(Integer.MAX_VALUE & StrictGeomUtility.toInternalValue(fontMetrics.getMaxHeight() - fontMetrics.getMaxDescent()));
    }

    public GlyphMetrics getCharacterSize(int codePoint, GlyphMetrics dimension) {
        int width = codePoint == Integer.MIN_VALUE || codePoint == Integer.MAX_VALUE ? 0 : (int)(Integer.MAX_VALUE & StrictGeomUtility.toInternalValue(this.fontMetrics.getCharWidth(codePoint)));
        if (dimension == null) {
            dimension = new GlyphMetrics();
        }
        dimension.setWidth(width);
        dimension.setHeight(this.maxHeight);
        dimension.setBaselinePosition(this.baseLine);
        return dimension;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

