/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.text.generator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.jfree.fonts.tools.ByteTable;

public class GraphemeClassifierGenerator {
    private static final int MAX_CHARS = 0x110000;
    private static final int MAX_RANGES = 4352;

    public static void main(String[] args) throws IOException {
        String line;
        File target;
        File f;
        if (args.length < 2) {
            System.out.println("Give the mapping files as first parameter and the target-file as second-parameter.");
            System.exit(1);
        }
        if (!((f = new File(args[0])).isFile() && f.exists() && f.canRead())) {
            System.out.println("Mapping file is not valid: " + f);
            System.exit(1);
        }
        if ((target = new File(args[1])).exists() && !target.canWrite()) {
            System.out.println("Target file is not valid: " + target);
            System.exit(1);
        }
        ByteTable table = new ByteTable(4352, 256);
        BufferedReader reader = new BufferedReader(new FileReader(f));
        while ((line = reader.readLine()) != null) {
            int separator;
            if (line.startsWith("#") || line.trim().length() == 0 || (separator = line.indexOf(59)) < 1) continue;
            int comment = line.indexOf(35);
            if (comment == -1) {
                comment = line.length();
            }
            String chars = line.substring(0, separator).trim();
            String classification = line.substring(separator + 1, comment).trim();
            int range = chars.indexOf("..");
            if (range == -1) {
                int idx = Integer.parseInt(chars, 16);
                int targetRange = idx >> 8;
                table.setByte(targetRange, idx & 0xFF, GraphemeClassifierGenerator.classify(classification));
                continue;
            }
            int startRange = Integer.parseInt(chars.substring(0, range), 16);
            int endRange = Integer.parseInt(chars.substring(range + 2), 16);
            for (int i = startRange; i < endRange; ++i) {
                int targetRange = i >> 8;
                table.setByte(targetRange, i & 0xFF, GraphemeClassifierGenerator.classify(classification));
            }
        }
        FileOutputStream targetStream = new FileOutputStream(target);
        ObjectOutputStream oout = new ObjectOutputStream(targetStream);
        oout.writeObject(table);
        oout.flush();
        targetStream.close();
    }

    private static byte classify(String text) {
        if ("CR".equalsIgnoreCase(text)) {
            return 1;
        }
        if ("LF".equalsIgnoreCase(text)) {
            return 2;
        }
        if ("Control".equalsIgnoreCase(text)) {
            return 3;
        }
        if ("Extend".equalsIgnoreCase(text)) {
            return 4;
        }
        if ("L".equalsIgnoreCase(text)) {
            return 8;
        }
        if ("LV".equalsIgnoreCase(text)) {
            return 24;
        }
        if ("LVT".equalsIgnoreCase(text)) {
            return 72;
        }
        if ("V".equalsIgnoreCase(text)) {
            return 56;
        }
        if ("T".equalsIgnoreCase(text)) {
            return 104;
        }
        if ("Other".equalsIgnoreCase(text)) {
            return 0;
        }
        throw new IllegalStateException("Parse Error: Classification is not known: " + text);
    }
}

