/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.text.whitespace;

import org.jfree.fonts.text.whitespace.WhiteSpaceFilter;

public class DiscardWhiteSpaceFilter
implements WhiteSpaceFilter {
    public static final char ZERO_WIDTH_NON_JOINER = '\u200c';
    private boolean lastWasWhiteSpace;

    public void reset() {
        this.lastWasWhiteSpace = false;
    }

    public int filter(int codepoint) {
        if (Character.isWhitespace((char)codepoint)) {
            if (!this.lastWasWhiteSpace) {
                this.lastWasWhiteSpace = true;
                return 8204;
            }
            return -1;
        }
        if (codepoint == Integer.MIN_VALUE) {
            this.lastWasWhiteSpace = true;
            return -1;
        }
        if (codepoint == Integer.MAX_VALUE) {
            return -1;
        }
        this.lastWasWhiteSpace = false;
        return codepoint;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

