/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.tools;

import org.jfree.fonts.LibFontBoot;
import org.jfree.fonts.registry.FontFamily;
import org.jfree.fonts.registry.FontRecord;
import org.jfree.fonts.registry.FontSource;
import org.jfree.fonts.truetype.TrueTypeFontRegistry;

public class ListFonts {
    private ListFonts() {
    }

    private static void printRecord(FontRecord record) {
        if (record == null) {
            System.out.println("  - (there is no font defined for that style and family.)");
            return;
        }
        System.out.println("  " + record.getFamily().getFamilyName() + " italics:" + record.isItalic() + " oblique:" + record.isOblique() + " bold: " + record.isBold());
        if (record instanceof FontSource) {
            FontSource source = (FontSource)record;
            String[] allNames = source.getAllNames();
            for (int i = 0; i < allNames.length; ++i) {
                String name = allNames[i];
                System.out.println("  Alias: " + i + " Name:" + name);
            }
            String[] allVariants = source.getAllVariants();
            for (int i = 0; i < allVariants.length; ++i) {
                String name = allVariants[i];
                System.out.println("  Variant: " + i + " Name:" + name);
            }
        }
    }

    public static void main(String[] args) {
        LibFontBoot.getInstance().start();
        TrueTypeFontRegistry registry = new TrueTypeFontRegistry();
        registry.initialize();
        String[] fontFamilies = registry.getRegisteredFamilies();
        for (int i = 0; i < fontFamilies.length; ++i) {
            String fontFamily = fontFamilies[i];
            FontFamily family = registry.getFontFamily(fontFamily);
            String[] names = family.getAllNames();
            ListFonts.printRecord(family.getFontRecord(true, false));
        }
    }
}

