/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.truetype;

import java.io.IOException;
import org.jfree.fonts.ByteAccessUtilities;
import org.jfree.fonts.truetype.FontTable;

public class FontHeaderTable
implements FontTable {
    public static final long TABLE_ID = 1751474532L;
    private static final long MAGIC = 1594834165L;
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_ITALIC = 2;
    public static final int STYLE_UNDERLINE = 4;
    public static final int STYLE_OUTLINE = 8;
    public static final int STYLE_SHADOW = 16;
    public static final int STYLE_CONDENSED = 32;
    public static final int STYLE_EXTENDED = 64;
    public static final int FEATURE_BASELINE = 1;
    public static final int FEATURE_LSB = 2;
    public static final int FEATURE_EXPLICIT_POINTSIZE = 4;
    public static final int FEATURE_INTEGER_SCALING = 8;
    public static final int FEATURE_NONLINEAR_WIDTH = 16;
    public static final int FEATURE_VERTICAL = 32;
    public static final int FEATURE_LAYOUT_REQUIRED = 128;
    public static final int FEATURE_METAMORPH = 256;
    public static final int FEATURE_RTL_GLYPHS = 512;
    public static final int FEATURE_INDIC_REARRANGE = 1024;
    public static final int FEATURE_COMPRESSED = 2048;
    public static final int FEATURE_CLEARTYPE = 4096;
    private long version;
    private long revision;
    private long checkSumAdjustment;
    private int flags;
    private int unitsPerEm;
    private long createdDate;
    private long modifiedDate;
    private int xMin;
    private int yMin;
    private int xMax;
    private int yMax;
    private int macStyle;
    private int lowestRecPPEM;
    private short fontDirectionHint;
    private short indexToLocFormat;
    private short glyphDataFormat;

    public FontHeaderTable(byte[] data) throws IOException {
        this.version = ByteAccessUtilities.readULong(data, 0);
        this.revision = ByteAccessUtilities.readULong(data, 4);
        this.checkSumAdjustment = ByteAccessUtilities.readULong(data, 8);
        if (ByteAccessUtilities.readULong(data, 12) != 1594834165L) {
            throw new IOException("MagicNumber missing");
        }
        this.flags = ByteAccessUtilities.readUShort(data, 16);
        this.unitsPerEm = ByteAccessUtilities.readUShort(data, 18);
        this.createdDate = ByteAccessUtilities.readLongDateTime(data, 20);
        this.modifiedDate = ByteAccessUtilities.readLongDateTime(data, 28);
        this.xMin = ByteAccessUtilities.readShort(data, 36);
        this.yMin = ByteAccessUtilities.readShort(data, 38);
        this.xMax = ByteAccessUtilities.readShort(data, 40);
        this.yMax = ByteAccessUtilities.readShort(data, 42);
        this.macStyle = ByteAccessUtilities.readUShort(data, 44);
        this.lowestRecPPEM = ByteAccessUtilities.readUShort(data, 46);
        this.fontDirectionHint = ByteAccessUtilities.readShort(data, 48);
        this.indexToLocFormat = ByteAccessUtilities.readShort(data, 50);
        this.glyphDataFormat = ByteAccessUtilities.readShort(data, 52);
    }

    public long getVersion() {
        return this.version;
    }

    public long getRevision() {
        return this.revision;
    }

    public long getCheckSumAdjustment() {
        return this.checkSumAdjustment;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getUnitsPerEm() {
        return this.unitsPerEm;
    }

    public long getCreatedDate() {
        return this.createdDate;
    }

    public long getModifiedDate() {
        return this.modifiedDate;
    }

    public int getxMin() {
        return this.xMin;
    }

    public int getyMin() {
        return this.yMin;
    }

    public int getxMax() {
        return this.xMax;
    }

    public int getyMax() {
        return this.yMax;
    }

    public int getMacStyle() {
        return this.macStyle;
    }

    public int getLowestRecPPEM() {
        return this.lowestRecPPEM;
    }

    public short getFontDirectionHint() {
        return this.fontDirectionHint;
    }

    public short getIndexToLocFormat() {
        return this.indexToLocFormat;
    }

    public short getGlyphDataFormat() {
        return this.glyphDataFormat;
    }

    public boolean isBold() {
        return (this.macStyle & 1) == 1;
    }

    public boolean isItalic() {
        return (this.macStyle & 2) == 2;
    }

    public long getName() {
        return 1751474532L;
    }
}

