/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.truetype;

import java.io.IOException;
import org.jfree.fonts.truetype.FontHeaderTable;
import org.jfree.fonts.truetype.HorizontalHeaderTable;
import org.jfree.fonts.truetype.OS2Table;
import org.jfree.fonts.truetype.TrueTypeFont;

public class ScalableTrueTypeFontMetrics {
    private TrueTypeFont font;
    private double ascent;
    private double descent;
    private double leading;
    private double xHeight;
    private double strikethroughPosition;
    private static final boolean preferMacSettings = false;
    private double overlinePosition;
    private double underlinePosition;

    public ScalableTrueTypeFontMetrics(TrueTypeFont font) throws IOException {
        if (font == null) {
            throw new NullPointerException("The font must not be null");
        }
        this.font = font;
        FontHeaderTable head = (FontHeaderTable)font.getTable(1751474532L);
        int unitsPerEm = head.getUnitsPerEm();
        OS2Table table = (OS2Table)font.getTable(1330851634L);
        if (table == null) {
            HorizontalHeaderTable hhea = (HorizontalHeaderTable)font.getTable(1751672161L);
            if (hhea != null) {
                this.createMacMetrics(hhea, unitsPerEm);
            } else {
                this.createFallbackMetrics();
            }
        } else {
            this.computeWindowsMetrics(table, unitsPerEm);
        }
        font.dispose();
    }

    private void createMacMetrics(HorizontalHeaderTable hhea, double unitsPerEm) {
        this.ascent = (double)hhea.getAscender() / unitsPerEm;
        this.descent = (double)hhea.getDescender() / unitsPerEm;
        this.leading = (double)hhea.getLineGap() / unitsPerEm;
        this.xHeight = this.ascent * 0.7142857142857143;
        this.strikethroughPosition = this.xHeight * 0.5;
    }

    private void createFallbackMetrics() {
        this.ascent = 0.7;
        this.descent = 0.3;
        this.xHeight = 0.5;
        this.strikethroughPosition = this.xHeight * 0.5;
        this.leading = 0.0;
    }

    private void computeWindowsMetrics(OS2Table table, double unitsPerEm) {
        int ascentRaw = table.getTypoAscender();
        this.ascent = ascentRaw == 0 ? (double)table.getWinAscent() / unitsPerEm : (double)ascentRaw / unitsPerEm;
        int descentRaw = table.getTypoDescender();
        this.descent = descentRaw == 0 ? -((double)table.getWinDescent() / unitsPerEm) : (double)descentRaw / unitsPerEm;
        int leadingRaw = table.getTypoLineGap();
        this.leading = (double)leadingRaw / unitsPerEm;
        short xHeightRaw = table.getxHeight();
        this.xHeight = xHeightRaw == 0 ? this.ascent * 0.7142857142857143 : (double)xHeightRaw / unitsPerEm;
        short strikethroughPosition = table.getyStrikeoutPosition();
        this.strikethroughPosition = strikethroughPosition == 0 ? this.xHeight * 0.5 : (double)strikethroughPosition / unitsPerEm;
    }

    public double getAscent() {
        return this.ascent;
    }

    public double getDescent() {
        return this.descent;
    }

    public double getLeading() {
        return this.leading;
    }

    public double getXHeight() {
        return this.xHeight;
    }

    public double getOverlinePosition() {
        return this.overlinePosition;
    }

    public double getUnderlinePosition() {
        return this.underlinePosition;
    }

    public double getStrikeThroughPosition() {
        return this.strikethroughPosition;
    }

    public TrueTypeFont getFont() {
        return this.font;
    }
}

