/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.truetype;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.jfree.fonts.ByteAccessUtilities;
import org.jfree.fonts.truetype.TrueTypeFont;

public class TrueTypeCollection {
    public static final long MAGIC_NUMBER = 1953784678L;
    private File filename;
    private long numFonts;
    private long[] offsets;
    private TrueTypeFont[] fonts;

    public TrueTypeCollection(File filename) throws IOException {
        this.filename = filename;
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        byte[] headerBuffer = new byte[12];
        raf.readFully(headerBuffer);
        if (ByteAccessUtilities.readULong(headerBuffer, 0) != 1953784678L) {
            throw new IOException();
        }
        this.numFonts = ByteAccessUtilities.readLong(headerBuffer, 8);
        byte[] offsetBuffer = new byte[(int)(4L * this.numFonts)];
        raf.readFully(offsetBuffer);
        int size = (int)this.numFonts;
        this.offsets = new long[size];
        this.fonts = new TrueTypeFont[size];
        for (int i = 0; i < size; ++i) {
            this.offsets[i] = ByteAccessUtilities.readULong(offsetBuffer, i * 4);
        }
    }

    public File getFilename() {
        return this.filename;
    }

    public long getNumFonts() {
        return this.numFonts;
    }

    public synchronized TrueTypeFont getFont(int index) throws IOException {
        TrueTypeFont font;
        TrueTypeFont cachedFont = this.fonts[index];
        if (cachedFont != null) {
            return cachedFont;
        }
        this.fonts[index] = font = new TrueTypeFont(this.filename, this.offsets[index], index);
        return font;
    }
}

