/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.truetype;

import org.jfree.fonts.registry.BaselineInfo;
import org.jfree.fonts.registry.FontMetrics;
import org.jfree.fonts.truetype.ScalableTrueTypeFontMetrics;

public class TrueTypeFontMetrics
implements FontMetrics {
    private ScalableTrueTypeFontMetrics fontMetrics;
    private double fontSize;

    public TrueTypeFontMetrics(ScalableTrueTypeFontMetrics fontMetrics, double fontSize) {
        if (fontMetrics == null) {
            throw new NullPointerException("The font must not be null");
        }
        this.fontMetrics = fontMetrics;
        this.fontSize = fontSize;
    }

    public double getAscent() {
        return this.fontSize * this.fontMetrics.getAscent();
    }

    public double getDescent() {
        return this.fontSize * this.fontMetrics.getDescent();
    }

    public double getLeading() {
        return this.fontSize * this.fontMetrics.getLeading();
    }

    public double getXHeight() {
        return this.fontSize * this.fontMetrics.getXHeight();
    }

    public double getOverlinePosition() {
        return this.fontSize * this.fontMetrics.getOverlinePosition();
    }

    public double getUnderlinePosition() {
        return this.fontSize * this.fontMetrics.getUnderlinePosition();
    }

    public double getStrikeThroughPosition() {
        return this.fontSize * this.fontMetrics.getStrikeThroughPosition();
    }

    public double getMaxAscent() {
        return this.fontSize * this.fontMetrics.getAscent();
    }

    public double getMaxDescent() {
        return this.fontSize * this.fontMetrics.getDescent();
    }

    public double getMaxLeading() {
        return this.fontSize * this.fontMetrics.getLeading();
    }

    public double getMaxHeight() {
        return this.getMaxAscent() - this.getMaxDescent() - this.getMaxLeading();
    }

    public double getMaxCharAdvance() {
        return 0.0;
    }

    public double getCharWidth(int character) {
        return 0.0;
    }

    public double getKerning(int previous, int character) {
        return 0.0;
    }

    public BaselineInfo getBaselines(int c, BaselineInfo info) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }
}

