/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.truetype;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.jfree.fonts.FontException;
import org.jfree.fonts.StringUtilities;
import org.jfree.fonts.registry.DefaultFontFamily;
import org.jfree.fonts.registry.FontFamily;
import org.jfree.fonts.registry.FontMetricsFactory;
import org.jfree.fonts.registry.FontRegistry;
import org.jfree.fonts.truetype.NameTable;
import org.jfree.fonts.truetype.TrueTypeCollection;
import org.jfree.fonts.truetype.TrueTypeFont;
import org.jfree.fonts.truetype.TrueTypeFontMetricsFactory;
import org.jfree.fonts.truetype.TrueTypeFontRecord;
import org.jfree.util.Log;
import org.jfree.util.LogContext;
import org.jfree.util.ObjectUtilities;

public class TrueTypeFontRegistry
implements FontRegistry,
Serializable {
    private static final FontPathFilter FONTPATHFILTER = new FontPathFilter();
    private static final LogContext logger = Log.createContext((Class)(class$org$jfree$fonts$truetype$TrueTypeFontRegistry == null ? (class$org$jfree$fonts$truetype$TrueTypeFontRegistry = TrueTypeFontRegistry.class$("org.jfree.fonts.truetype.TrueTypeFontRegistry")) : class$org$jfree$fonts$truetype$TrueTypeFontRegistry));
    private HashMap seenFiles = new HashMap();
    private TreeMap fontFamilies = new TreeMap();
    private TreeMap alternateFamilyNames = new TreeMap();
    private TreeMap fullFontNames = new TreeMap();
    static /* synthetic */ Class class$org$jfree$fonts$truetype$TrueTypeFontRegistry;

    public synchronized void registerDefaultFontPath() {
        String osname = this.safeSystemGetProperty("os.name", "<protected by system security>");
        String jrepath = this.safeSystemGetProperty("java.home", ".");
        String fs = this.safeSystemGetProperty("file.separator", File.separator);
        logger.debug((Object)("Running on operating system: " + osname));
        if (this.safeSystemGetProperty("mrj.version", null) != null) {
            String userhome = this.safeSystemGetProperty("user.home", ".");
            logger.debug((Object)"Detected MacOS (Property 'mrj.version' is present.");
            this.internalRegisterFontPath(new File(userhome + "/Library/Fonts"));
            this.internalRegisterFontPath(new File("/Library/Fonts"));
            this.internalRegisterFontPath(new File("/Network/Library/Fonts"));
            this.internalRegisterFontPath(new File("/System/Library/Fonts"));
        } else if (StringUtilities.startsWithIgnoreCase(osname, "windows")) {
            this.registerWindowsFontPath();
        } else {
            logger.debug((Object)"Assuming unix like file structures");
            this.internalRegisterFontPath(new File("/usr/X11R6/lib/X11/fonts"));
            this.internalRegisterFontPath(new File("/usr/share/fonts"));
        }
        this.internalRegisterFontPath(new File(jrepath, "lib" + fs + "fonts"));
    }

    private String safeSystemGetProperty(String name, String defaultValue) {
        try {
            return System.getProperty(name, defaultValue);
        }
        catch (SecurityException se) {
            return defaultValue;
        }
    }

    private void registerWindowsFontPath() {
        logger.debug((Object)"Found windows in os name, assuming DOS/Win32 structures");
        String fontPath = null;
        String windirs = this.safeSystemGetProperty("java.library.path", null);
        String fs = this.safeSystemGetProperty("file.separator", File.separator);
        if (windirs != null) {
            StringTokenizer strtok = new StringTokenizer(windirs, this.safeSystemGetProperty("path.separator", File.pathSeparator));
            while (strtok.hasMoreTokens()) {
                String token = strtok.nextToken();
                if (!StringUtilities.endsWithIgnoreCase(token, "System32")) continue;
                int lastBackslash = token.lastIndexOf(fs);
                fontPath = token.substring(0, lastBackslash) + fs + "Fonts";
                break;
            }
        }
        logger.debug((Object)("Fonts located in \"" + fontPath + "\""));
        if (fontPath != null) {
            File file = new File(fontPath);
            this.internalRegisterFontPath(file);
        }
    }

    public synchronized void registerFontPath(File file) {
        this.internalRegisterFontPath(file);
    }

    private synchronized void internalRegisterFontPath(File file) {
        if (!file.exists()) {
            return;
        }
        if (!file.isDirectory()) {
            return;
        }
        if (!file.canRead()) {
            return;
        }
        File[] files = file.listFiles(FONTPATHFILTER);
        for (int i = 0; i < files.length; ++i) {
            File currentFile = files[i];
            if (currentFile.isDirectory()) {
                this.internalRegisterFontPath(currentFile);
                continue;
            }
            try {
                this.registerFontFile(currentFile);
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public void registerFontFile(File currentFile) throws IOException {
        FontFileRecord record = new FontFileRecord(currentFile);
        FontFileRecord cachedRecord = (FontFileRecord)this.seenFiles.get(record.getFilename());
        if (ObjectUtilities.equal((Object)record, (Object)cachedRecord)) {
            return;
        }
        this.internalRegisterFontFile(currentFile);
        this.seenFiles.put(record.getFilename(), record);
    }

    private void internalRegisterFontFile(File file) {
        try {
            if (StringUtilities.endsWithIgnoreCase(file.getName(), ".ttc")) {
                TrueTypeCollection ttc = new TrueTypeCollection(file);
                int i = 0;
                while ((long)i < ttc.getNumFonts()) {
                    TrueTypeFont font = ttc.getFont(i);
                    this.registerTrueTypeFont(font);
                    font.dispose();
                    ++i;
                }
            } else {
                TrueTypeFont font = new TrueTypeFont(file);
                this.registerTrueTypeFont(font);
                font.dispose();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void registerTrueTypeFont(TrueTypeFont font) throws IOException {
        NameTable table = (NameTable)font.getTable(1851878757L);
        if (table == null) {
            throw new IOException("The NameTable is required for all conforming fonts.");
        }
        String familyName = table.getPrimaryName(1);
        String[] allNames = table.getAllNames(1);
        DefaultFontFamily fontFamily = this.createFamily(familyName);
        this.alternateFamilyNames.put(familyName, fontFamily);
        for (int i = 0; i < allNames.length; ++i) {
            String name = allNames[i];
            fontFamily.addName(name);
            this.alternateFamilyNames.put(name, fontFamily);
        }
        String[] allFullNames = table.getAllNames(4);
        for (int i = 0; i < allFullNames.length; ++i) {
            String name = allFullNames[i];
            this.fullFontNames.put(name, fontFamily);
        }
        try {
            TrueTypeFontRecord record = new TrueTypeFontRecord(font, fontFamily);
            fontFamily.setFontRecord(record);
        }
        catch (FontException e) {
            Log.info((Object)("The font '" + font.getFilename() + "' is invalid."));
        }
    }

    private DefaultFontFamily createFamily(String name) {
        DefaultFontFamily fontFamily = (DefaultFontFamily)this.fontFamilies.get(name);
        if (fontFamily != null) {
            return fontFamily;
        }
        DefaultFontFamily createdFamily = new DefaultFontFamily(name);
        this.fontFamilies.put(name, createdFamily);
        return createdFamily;
    }

    public String[] getRegisteredFamilies() {
        return this.fontFamilies.keySet().toArray(new String[this.fontFamilies.size()]);
    }

    public String[] getAllRegisteredFamilies() {
        return this.alternateFamilyNames.keySet().toArray(new String[this.alternateFamilyNames.size()]);
    }

    public void initialize() {
        this.registerDefaultFontPath();
    }

    public FontFamily getFontFamily(String name) {
        FontFamily primary = (FontFamily)this.fontFamilies.get(name);
        if (primary != null) {
            return primary;
        }
        FontFamily secondary = (FontFamily)this.alternateFamilyNames.get(name);
        if (secondary != null) {
            return secondary;
        }
        return (FontFamily)this.fullFontNames.get(name);
    }

    public FontMetricsFactory createMetricsFactory() {
        return new TrueTypeFontMetricsFactory();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class FontPathFilter
    implements FileFilter,
    Serializable {
        public boolean accept(File pathname) {
            if (!pathname.canRead()) {
                return false;
            }
            if (pathname.isDirectory()) {
                return true;
            }
            String name = pathname.getName();
            if (StringUtilities.endsWithIgnoreCase(name, ".ttf")) {
                return true;
            }
            if (StringUtilities.endsWithIgnoreCase(name, ".ttc")) {
                return true;
            }
            return StringUtilities.endsWithIgnoreCase(name, ".otf");
        }
    }

    private static class FontFileRecord
    implements Serializable {
        private long lastAccessTime;
        private long fileSize;
        private String filename;

        public FontFileRecord(File file) throws IOException {
            this(file.getCanonicalPath(), file.length(), file.lastModified());
        }

        public FontFileRecord(String filename, long fileSize, long lastAccessTime) {
            if (filename == null) {
                throw new NullPointerException();
            }
            this.filename = filename;
            this.fileSize = fileSize;
            this.lastAccessTime = lastAccessTime;
        }

        public long getLastAccessTime() {
            return this.lastAccessTime;
        }

        public long getFileSize() {
            return this.fileSize;
        }

        public String getFilename() {
            return this.filename;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FontFileRecord that = (FontFileRecord)o;
            if (this.fileSize != that.fileSize) {
                return false;
            }
            if (this.lastAccessTime != that.lastAccessTime) {
                return false;
            }
            return this.filename.equals(that.filename);
        }

        public int hashCode() {
            int result = (int)(this.lastAccessTime ^ this.lastAccessTime >>> 32);
            result = 29 * result + (int)(this.fileSize ^ this.fileSize >>> 32);
            result = 29 * result + this.filename.hashCode();
            return result;
        }
    }
}

