/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.resourceloader;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class ResourceKey
implements Serializable {
    private static final Map EMPTY_MAP = Collections.unmodifiableMap(new HashMap());
    private Map factoryParameters;
    private Integer hashCode;
    private Object schema;
    private Object identifier;
    private ResourceKey parent;

    public ResourceKey(Object schema, Object identifier, Map factoryParameters) {
        if (schema == null) {
            throw new NullPointerException();
        }
        if (identifier == null) {
            throw new NullPointerException();
        }
        this.schema = schema;
        this.identifier = identifier;
        this.factoryParameters = factoryParameters != null ? Collections.unmodifiableMap(new HashMap(factoryParameters)) : EMPTY_MAP;
    }

    public ResourceKey(ResourceKey parent, Object schema, Object identifier, Map factoryParameters) {
        this(schema, identifier, factoryParameters);
        this.parent = parent;
    }

    public ResourceKey getParent() {
        return this.parent;
    }

    public Map getFactoryParameters() {
        return this.factoryParameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceKey that = (ResourceKey)o;
        if (!this.schema.equals(that.schema)) {
            return false;
        }
        if (!((Object)this.factoryParameters).equals(that.factoryParameters)) {
            return false;
        }
        if (!this.identifier.equals(that.identifier)) {
            if (this.identifier instanceof byte[] && that.identifier instanceof byte[]) {
                byte[] me = (byte[])this.identifier;
                byte[] he = (byte[])that.identifier;
                Arrays.equals(me, he);
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hashCode == null) {
            int result = ((Object)this.factoryParameters).hashCode();
            result = 29 * result + this.schema.hashCode();
            result = 29 * result + this.identifier.hashCode();
            this.hashCode = new Integer(result);
        }
        return this.hashCode;
    }

    public Object getIdentifier() {
        return this.identifier;
    }

    public Object getSchema() {
        return this.schema;
    }

    public String toString() {
        return "ResourceKey{schema=" + this.schema + ", identifier=" + this.identifier + ", factoryParameters=" + this.factoryParameters + ", parent=" + this.parent + '}';
    }
}

