/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.resourceloader;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jfree.resourceloader.ContentNotRecognizedException;
import org.jfree.resourceloader.LibLoaderBoot;
import org.jfree.resourceloader.Resource;
import org.jfree.resourceloader.ResourceCreationException;
import org.jfree.resourceloader.ResourceData;
import org.jfree.resourceloader.ResourceFactory;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.ResourceKeyCreationException;
import org.jfree.resourceloader.ResourceLoader;
import org.jfree.resourceloader.ResourceLoadingException;
import org.jfree.resourceloader.cache.NullResourceDataCache;
import org.jfree.resourceloader.cache.NullResourceFactoryCache;
import org.jfree.resourceloader.cache.ResourceDataCache;
import org.jfree.resourceloader.cache.ResourceDataCacheEntry;
import org.jfree.resourceloader.cache.ResourceDataCacheProvider;
import org.jfree.resourceloader.cache.ResourceFactoryCache;
import org.jfree.resourceloader.cache.ResourceFactoryCacheProvider;
import org.jfree.util.Configuration;
import org.jfree.util.Log;
import org.jfree.util.ObjectUtilities;

public class ResourceManager {
    private static final Set failedModules = new HashSet();
    private ArrayList resourceLoaders = new ArrayList();
    private ArrayList resourceFactories = new ArrayList();
    private ResourceDataCache dataCache = new NullResourceDataCache();
    private ResourceFactoryCache factoryCache = new NullResourceFactoryCache();
    private static final String LOADER_PREFIX = "org.jfree.resourceloader.loader.";
    private static final String FACTORY_TYPE_PREFIX = "org.jfree.resourceloader.factory.type.";
    public static final String DATA_CACHE_PROVIDER_KEY = "org.jfree.resourceloader.cache.DataCacheProvider";
    public static final String FACTORY_CACHE_PROVIDER_KEY = "org.jfree.resourceloader.cache.FactoryCacheProvider";
    static /* synthetic */ Class class$org$jfree$resourceloader$ResourceManager;
    static /* synthetic */ Class class$org$jfree$resourceloader$ResourceFactory;
    static /* synthetic */ Class class$org$jfree$resourceloader$cache$ResourceDataCacheProvider;
    static /* synthetic */ Class class$org$jfree$resourceloader$cache$ResourceFactoryCacheProvider;
    static /* synthetic */ Class class$org$jfree$resourceloader$ResourceLoader;

    public synchronized ResourceKey createKey(Object data) throws ResourceKeyCreationException {
        return this.createKey(data, null);
    }

    public synchronized ResourceKey createKey(Object data, Map parameters) throws ResourceKeyCreationException {
        if (data == null) {
            throw new NullPointerException("Key data must not be null.");
        }
        Iterator values = this.resourceLoaders.iterator();
        while (values.hasNext()) {
            ResourceLoader loader = (ResourceLoader)values.next();
            try {
                ResourceKey key = loader.createKey(data, parameters);
                if (key == null) continue;
                return key;
            }
            catch (ResourceKeyCreationException rkce) {
            }
        }
        throw new ResourceKeyCreationException("Unable to create key: No loader was able to handle the given key data: " + data);
    }

    public ResourceKey deriveKey(ResourceKey parent, String path) throws ResourceKeyCreationException {
        return this.deriveKey(parent, path, null);
    }

    public ResourceKey deriveKey(ResourceKey parent, String path, Map parameters) throws ResourceKeyCreationException {
        ResourceKey key;
        ResourceLoader loader;
        int i;
        if (path == null) {
            throw new NullPointerException("Key data must not be null.");
        }
        if (parent == null) {
            return this.createKey(path, parameters);
        }
        ResourceKeyCreationException rce = null;
        for (i = 0; i < this.resourceLoaders.size(); ++i) {
            loader = (ResourceLoader)this.resourceLoaders.get(i);
            if (!loader.isSupportedKey(parent)) continue;
            try {
                key = loader.deriveKey(parent, path, parameters);
                if (key == null) continue;
                return key;
            }
            catch (ResourceKeyCreationException rcke) {
                rce = rcke;
            }
        }
        for (i = 0; i < this.resourceLoaders.size(); ++i) {
            loader = (ResourceLoader)this.resourceLoaders.get(i);
            key = loader.createKey(path, parameters);
            if (key == null) continue;
            return key;
        }
        if (rce != null) {
            throw rce;
        }
        throw new ResourceKeyCreationException("Unable to create key: No such schema or the key was not recognized.");
    }

    private ResourceLoader findBySchema(ResourceKey key) {
        for (int i = 0; i < this.resourceLoaders.size(); ++i) {
            ResourceLoader loader = (ResourceLoader)this.resourceLoaders.get(i);
            if (!loader.isSupportedKey(key)) continue;
            return loader;
        }
        return null;
    }

    public URL toURL(ResourceKey key) {
        ResourceLoader loader = this.findBySchema(key);
        if (loader == null) {
            return null;
        }
        return loader.toURL(key);
    }

    public ResourceData load(ResourceKey key) throws ResourceLoadingException {
        ResourceData data;
        ResourceLoader loader = this.findBySchema(key);
        if (loader == null) {
            throw new ResourceLoadingException("Invalid key: No resource-loader registered for schema: " + key.getSchema());
        }
        ResourceDataCacheEntry cached = this.dataCache.get(key);
        if (cached != null) {
            data = cached.getData();
            if (cached.getStoredVersion() < 0L) {
                return data;
            }
            long version = data.getVersion(this);
            if (version < 0L) {
                this.dataCache.remove(data);
            } else {
                if (cached.getStoredVersion() == version) {
                    return data;
                }
                this.dataCache.remove(data);
            }
        }
        data = loader.load(key);
        return this.dataCache.put(this, data);
    }

    public Resource createDirectly(Object keyValue, Class target) throws ResourceLoadingException, ResourceCreationException, ResourceKeyCreationException {
        ResourceKey key = this.createKey(keyValue);
        return this.create(key, null, target);
    }

    public Resource create(ResourceKey key, ResourceKey context, Class target) throws ResourceLoadingException, ResourceCreationException {
        if (target == null) {
            throw new NullPointerException("Target must not be null");
        }
        if (key == null) {
            throw new NullPointerException("Key must not be null.");
        }
        return this.create(key, context, new Class[]{target});
    }

    public Resource create(ResourceKey key, ResourceKey context) throws ResourceLoadingException, ResourceCreationException {
        return this.create(key, context, (Class[])null);
    }

    public Resource create(ResourceKey key, ResourceKey context, Class[] target) throws ResourceLoadingException, ResourceCreationException {
        if (key == null) {
            throw new NullPointerException("Key must not be null.");
        }
        Resource resource = this.factoryCache.get(key);
        if (resource != null) {
            if (this.isResourceUnchanged(resource)) {
                return resource;
            }
            this.factoryCache.remove(resource);
        }
        if (target == null) {
            return this.autoCreateResource(key, context);
        }
        ResourceCreationException exception = null;
        ResourceData data = this.load(key);
        for (int i = 0; i < this.resourceFactories.size(); ++i) {
            ResourceFactory fact = (ResourceFactory)this.resourceFactories.get(i);
            if (!this.isSupportedTarget(target, fact)) continue;
            try {
                return this.performCreate(data, fact, context);
            }
            catch (ContentNotRecognizedException ce) {
                continue;
            }
            catch (ResourceCreationException rex) {
                exception = rex;
                if (!Log.isDebugEnabled()) continue;
                Log.debug((Object)("Failed at " + fact.getClass() + ": "), (Exception)((Object)rex));
            }
        }
        if (exception != null) {
            throw exception;
        }
        throw new ContentNotRecognizedException("None of the selected factories was able to handle the given data: " + key);
    }

    private boolean isSupportedTarget(Class[] target, ResourceFactory fact) {
        Class factoryType = fact.getFactoryType();
        for (int j = 0; j < target.length; ++j) {
            Class aClass = target[j];
            if (aClass == null || !aClass.isAssignableFrom(factoryType)) continue;
            return true;
        }
        return false;
    }

    private Resource autoCreateResource(ResourceKey key, ResourceKey context) throws ResourceLoadingException, ResourceCreationException {
        ResourceData data = this.load(key);
        Iterator it = this.resourceFactories.iterator();
        while (it.hasNext()) {
            ResourceFactory fact = (ResourceFactory)it.next();
            try {
                Resource res = this.performCreate(data, fact, context);
                if (res == null) continue;
                return res;
            }
            catch (ResourceCreationException rex) {
            }
        }
        throw new ResourceCreationException("No known factory was able to handle the given data.");
    }

    private Resource performCreate(ResourceData data, ResourceFactory fact, ResourceKey context) throws ResourceLoadingException, ResourceCreationException {
        Resource created = fact.create(this, data, context);
        this.factoryCache.put(created);
        return created;
    }

    private boolean isResourceUnchanged(Resource resource) throws ResourceLoadingException {
        ResourceKey[] deps = resource.getDependencies();
        for (int i = 0; i < deps.length; ++i) {
            ResourceData data;
            ResourceKey dep = deps[i];
            long version = resource.getVersion(dep);
            if (version == -1L || (data = this.load(dep)).getVersion(this) == version) continue;
            return false;
        }
        return true;
    }

    public ResourceDataCache getDataCache() {
        return this.dataCache;
    }

    public void setDataCache(ResourceDataCache dataCache) {
        if (dataCache == null) {
            throw new NullPointerException();
        }
        this.dataCache = dataCache;
    }

    public ResourceFactoryCache getFactoryCache() {
        return this.factoryCache;
    }

    public void setFactoryCache(ResourceFactoryCache factoryCache) {
        if (factoryCache == null) {
            throw new NullPointerException();
        }
        this.factoryCache = factoryCache;
    }

    public void registerDefaults() {
        this.registerDefaultLoaders();
        this.registerDefaultFactories();
        this.registerDataCache();
        this.registerFactoryCache();
    }

    public void registerDefaultFactories() {
        Configuration config = LibLoaderBoot.getInstance().getGlobalConfig();
        Iterator itType = config.findPropertyKeys(FACTORY_TYPE_PREFIX);
        while (itType.hasNext()) {
            String key = (String)itType.next();
            String factoryClass = config.getConfigProperty(key);
            Object maybeFactory = ObjectUtilities.loadAndInstantiate((String)factoryClass, (Class)(class$org$jfree$resourceloader$ResourceManager == null ? ResourceManager.class$("org.jfree.resourceloader.ResourceManager") : class$org$jfree$resourceloader$ResourceManager), (Class)(class$org$jfree$resourceloader$ResourceFactory == null ? ResourceManager.class$("org.jfree.resourceloader.ResourceFactory") : class$org$jfree$resourceloader$ResourceFactory));
            if (!(maybeFactory instanceof ResourceFactory)) continue;
            ResourceFactory factory = (ResourceFactory)maybeFactory;
            factory.initializeDefaults();
            this.registerFactory(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDataCache() {
        Configuration config = LibLoaderBoot.getInstance().getGlobalConfig();
        String dataCacheProviderClass = config.getConfigProperty(DATA_CACHE_PROVIDER_KEY);
        if (dataCacheProviderClass == null) {
            return;
        }
        Object maybeDataCacheProvider = ObjectUtilities.loadAndInstantiate((String)dataCacheProviderClass, (Class)(class$org$jfree$resourceloader$ResourceManager == null ? (class$org$jfree$resourceloader$ResourceManager = ResourceManager.class$("org.jfree.resourceloader.ResourceManager")) : class$org$jfree$resourceloader$ResourceManager), (Class)(class$org$jfree$resourceloader$cache$ResourceDataCacheProvider == null ? (class$org$jfree$resourceloader$cache$ResourceDataCacheProvider = ResourceManager.class$("org.jfree.resourceloader.cache.ResourceDataCacheProvider")) : class$org$jfree$resourceloader$cache$ResourceDataCacheProvider));
        if (maybeDataCacheProvider instanceof ResourceDataCacheProvider) {
            ResourceDataCacheProvider provider = (ResourceDataCacheProvider)maybeDataCacheProvider;
            try {
                ResourceDataCache cache = provider.createDataCache();
                if (cache != null) {
                    this.setDataCache(cache);
                }
            }
            catch (Throwable e) {
                Set set = failedModules;
                synchronized (set) {
                    if (!failedModules.contains(dataCacheProviderClass)) {
                        Log.warn((Object)("Failed to create data cache: " + e.getLocalizedMessage()));
                        failedModules.add(dataCacheProviderClass);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFactoryCache() {
        Configuration config = LibLoaderBoot.getInstance().getGlobalConfig();
        String cacheProviderClass = config.getConfigProperty(FACTORY_CACHE_PROVIDER_KEY);
        if (cacheProviderClass == null) {
            return;
        }
        Object maybeCacheProvider = ObjectUtilities.loadAndInstantiate((String)cacheProviderClass, (Class)(class$org$jfree$resourceloader$ResourceManager == null ? (class$org$jfree$resourceloader$ResourceManager = ResourceManager.class$("org.jfree.resourceloader.ResourceManager")) : class$org$jfree$resourceloader$ResourceManager), (Class)(class$org$jfree$resourceloader$cache$ResourceFactoryCacheProvider == null ? (class$org$jfree$resourceloader$cache$ResourceFactoryCacheProvider = ResourceManager.class$("org.jfree.resourceloader.cache.ResourceFactoryCacheProvider")) : class$org$jfree$resourceloader$cache$ResourceFactoryCacheProvider));
        if (maybeCacheProvider != null) {
            ResourceFactoryCacheProvider provider = (ResourceFactoryCacheProvider)maybeCacheProvider;
            try {
                ResourceFactoryCache cache = provider.createFactoryCache();
                if (cache != null) {
                    this.setFactoryCache(cache);
                }
            }
            catch (Throwable e) {
                Set set = failedModules;
                synchronized (set) {
                    if (!failedModules.contains(cacheProviderClass)) {
                        Log.warn((Object)("Failed to create factory cache: " + e.getLocalizedMessage()));
                        failedModules.add(cacheProviderClass);
                    }
                }
            }
        }
    }

    public void registerDefaultLoaders() {
        Configuration config = LibLoaderBoot.getInstance().getGlobalConfig();
        Iterator it = config.findPropertyKeys(LOADER_PREFIX);
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = config.getConfigProperty(key);
            Object o = ObjectUtilities.loadAndInstantiate((String)value, (Class)(class$org$jfree$resourceloader$ResourceManager == null ? ResourceManager.class$("org.jfree.resourceloader.ResourceManager") : class$org$jfree$resourceloader$ResourceManager), (Class)(class$org$jfree$resourceloader$ResourceLoader == null ? ResourceManager.class$("org.jfree.resourceloader.ResourceLoader") : class$org$jfree$resourceloader$ResourceLoader));
            if (o == null) continue;
            ResourceLoader loader = (ResourceLoader)o;
            this.registerLoader(loader);
        }
    }

    public void registerLoader(ResourceLoader loader) {
        if (loader == null) {
            throw new NullPointerException("ResourceLoader must not be null.");
        }
        loader.setResourceManager(this);
        this.resourceLoaders.add(loader);
    }

    public void registerFactory(ResourceFactory factory) {
        if (factory == null) {
            throw new NullPointerException("ResourceFactory must not be null.");
        }
        this.resourceFactories.add(factory);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

