/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.resourceloader.factory;

import java.io.IOException;
import java.io.InputStream;
import org.jfree.resourceloader.ResourceCreationException;
import org.jfree.resourceloader.ResourceData;
import org.jfree.resourceloader.ResourceLoadingException;
import org.jfree.resourceloader.ResourceManager;
import org.jfree.resourceloader.factory.FactoryModule;

public abstract class AbstractFactoryModule
implements FactoryModule {
    protected AbstractFactoryModule() {
    }

    protected abstract int[] getFingerPrint();

    protected abstract String[] getMimeTypes();

    protected abstract String[] getFileExtensions();

    public int canHandleResource(ResourceManager caller, ResourceData data) throws ResourceCreationException, ResourceLoadingException {
        try {
            if (this.canHandleResourceByContent(data.getResourceAsStream(caller))) {
                return 4000;
            }
            String mimeType = (String)data.getAttribute("content-type");
            if (mimeType != null && this.canHandleResourceByMimeType(mimeType)) {
                return 2000;
            }
            String fileName = (String)data.getAttribute("filename");
            if (fileName != null && this.canHandleResourceByName(fileName)) {
                return 2000;
            }
            return -1;
        }
        catch (ResourceLoadingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceCreationException("Failed to load or check content", e);
        }
    }

    protected boolean canHandleResourceByContent(InputStream data) throws IOException {
        int[] fingerprint = this.getFingerPrint();
        if (fingerprint.length == 0) {
            return false;
        }
        for (int i = 0; i < fingerprint.length; ++i) {
            if (fingerprint[i] == data.read()) continue;
            return false;
        }
        return true;
    }

    protected boolean canHandleResourceByMimeType(String name) {
        String[] mimes = this.getMimeTypes();
        for (int i = 0; i < mimes.length; ++i) {
            if (!name.equals(mimes[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean canHandleResourceByName(String name) {
        String[] fexts = this.getFileExtensions();
        for (int i = 0; i < fexts.length; ++i) {
            if (!name.equalsIgnoreCase(fexts[i])) continue;
            return true;
        }
        return false;
    }
}

