/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.resourceloader.factory;

import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import org.jfree.resourceloader.ContentNotRecognizedException;
import org.jfree.resourceloader.LibLoaderBoot;
import org.jfree.resourceloader.Resource;
import org.jfree.resourceloader.ResourceCreationException;
import org.jfree.resourceloader.ResourceData;
import org.jfree.resourceloader.ResourceFactory;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.ResourceLoadingException;
import org.jfree.resourceloader.ResourceManager;
import org.jfree.resourceloader.factory.FactoryModule;
import org.jfree.util.Configuration;
import org.jfree.util.ObjectUtilities;

public abstract class AbstractResourceFactory
implements ResourceFactory {
    private HashSet factoryModules;
    private Class factoryType;
    static /* synthetic */ Class class$org$jfree$resourceloader$factory$AbstractResourceFactory;
    static /* synthetic */ Class class$org$jfree$resourceloader$factory$FactoryModule;

    protected AbstractResourceFactory(Class factoryType) {
        if (factoryType == null) {
            throw new NullPointerException();
        }
        this.factoryType = factoryType;
        this.factoryModules = new HashSet();
    }

    public Class getFactoryType() {
        return this.factoryType;
    }

    public void initializeDefaults() {
        String type = this.getFactoryType().getName();
        String prefix = "org.jfree.resourceloader.factory.modules." + type;
        Configuration config = LibLoaderBoot.getInstance().getGlobalConfig();
        Iterator itType = config.findPropertyKeys(prefix);
        while (itType.hasNext()) {
            String key = (String)itType.next();
            String modClass = config.getConfigProperty(key);
            Object maybeFactory = ObjectUtilities.loadAndInstantiate((String)modClass, (Class)(class$org$jfree$resourceloader$factory$AbstractResourceFactory == null ? AbstractResourceFactory.class$("org.jfree.resourceloader.factory.AbstractResourceFactory") : class$org$jfree$resourceloader$factory$AbstractResourceFactory), (Class)(class$org$jfree$resourceloader$factory$FactoryModule == null ? AbstractResourceFactory.class$("org.jfree.resourceloader.factory.FactoryModule") : class$org$jfree$resourceloader$factory$FactoryModule));
            if (!(maybeFactory instanceof FactoryModule)) continue;
            this.registerModule((FactoryModule)maybeFactory);
        }
    }

    public synchronized boolean registerModule(String className) {
        try {
            Class<?> c = ObjectUtilities.getClassLoader(this.getClass()).loadClass(className);
            this.registerModule((FactoryModule)c.newInstance());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public synchronized void registerModule(FactoryModule module) {
        if (this.factoryModules.contains(module)) {
            return;
        }
        this.factoryModules.add(module);
    }

    public synchronized Resource create(ResourceManager manager, ResourceData data, ResourceKey context) throws ResourceCreationException, ResourceLoadingException {
        TreeSet<ResourceFactoryEntry> sortedEntries = new TreeSet<ResourceFactoryEntry>();
        Iterator factoryModulesIt = this.factoryModules.iterator();
        while (factoryModulesIt.hasNext()) {
            FactoryModule mod = (FactoryModule)factoryModulesIt.next();
            int weight = mod.canHandleResource(manager, data);
            if (weight < 0) continue;
            sortedEntries.add(new ResourceFactoryEntry(mod, weight));
        }
        Iterator it = sortedEntries.iterator();
        while (it.hasNext()) {
            ResourceFactoryEntry entry = (ResourceFactoryEntry)it.next();
            try {
                return entry.getModule().create(manager, data, context);
            }
            catch (Exception ex) {
            }
        }
        throw new ContentNotRecognizedException("No valid handler for the given content.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ResourceFactoryEntry
    implements Comparable {
        private FactoryModule module;
        private int weight;

        public ResourceFactoryEntry(FactoryModule module, int weight) {
            this.module = module;
            this.weight = weight;
        }

        public FactoryModule getModule() {
            return this.module;
        }

        public int getWeight() {
            return this.weight;
        }

        public int compareTo(Object o) {
            ResourceFactoryEntry entry = (ResourceFactoryEntry)o;
            return entry.weight - this.weight;
        }
    }
}

