/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.resourceloader.loader;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.jfree.io.IOUtils;
import org.jfree.resourceloader.ResourceData;
import org.jfree.resourceloader.ResourceLoadingException;
import org.jfree.resourceloader.ResourceManager;

public abstract class AbstractResourceData
implements ResourceData,
Serializable {
    protected AbstractResourceData() {
    }

    public byte[] getResource(ResourceManager caller) throws ResourceLoadingException {
        try {
            InputStream in = this.getResourceAsStream(caller);
            if (in == null) {
                throw new ResourceLoadingException("Unable to read Stream: No input stream: " + this.getKey());
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            IOUtils.getInstance().copyStreams(in, (OutputStream)bout);
            in.close();
            return bout.toByteArray();
        }
        catch (ResourceLoadingException rle) {
            throw rle;
        }
        catch (IOException e) {
            throw new ResourceLoadingException("Unable to read Stream: ", e);
        }
    }

    public int getResource(ResourceManager caller, byte[] target, int offset, int length) throws ResourceLoadingException {
        try {
            if (target == null) {
                throw new NullPointerException();
            }
            if (target.length < offset + length) {
                throw new IndexOutOfBoundsException();
            }
            InputStream in = this.getResourceAsStream(caller);
            if (in == null) {
                throw new ResourceLoadingException("Unable to read Stream: No input stream: " + this.getKey());
            }
            if (offset > 0) {
                long toBeSkipped = offset;
                long skipResult = in.skip(toBeSkipped);
                toBeSkipped -= skipResult;
                while (skipResult > 0L && toBeSkipped > 0L) {
                    skipResult = in.skip(offset);
                    toBeSkipped -= skipResult;
                }
                if (toBeSkipped > 0L) {
                    throw new ResourceLoadingException("Unable to read Stream: Skipping content failed: " + this.getKey());
                }
            }
            int bytesToRead = length;
            int bytesRead = in.read(target, length - bytesToRead, bytesToRead);
            while (bytesRead > -1 && bytesToRead > 0) {
                bytesRead = in.read(target, length - (bytesToRead -= bytesRead), bytesToRead);
            }
            in.close();
            return length - bytesRead;
        }
        catch (ResourceLoadingException rle) {
            throw rle;
        }
        catch (IOException e) {
            throw new ResourceLoadingException("Unable to read Stream: ", e);
        }
    }
}

