/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.resourceloader.loader;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.jfree.resourceloader.ResourceKeyCreationException;

public class LoaderUtils {
    private LoaderUtils() {
    }

    public static String mergePaths(String parent, String child) throws ResourceKeyCreationException {
        String parentPrefix;
        String parentResource;
        int childPrefix = child.indexOf("://");
        if (childPrefix > 0) {
            return child;
        }
        int parentPrefixPos = parent.indexOf("://");
        if (parentPrefixPos > 0) {
            parentResource = parent.substring(parentPrefixPos + 3);
            parentPrefix = parent.substring(0, parentPrefixPos + 3);
        } else {
            parentResource = parent;
            parentPrefix = "";
        }
        List parentList = parentResource.endsWith("/") ? LoaderUtils.parseName(parentResource, false) : LoaderUtils.parseName(parentResource, true);
        parentList.addAll(LoaderUtils.parseName(child, false));
        ArrayList<String> normalizedList = new ArrayList<String>();
        for (int i = 0; i < parentList.size(); ++i) {
            String o = (String)parentList.get(i);
            if (".".equals(o)) continue;
            if ("..".equals(o)) {
                if (normalizedList.isEmpty()) continue;
                normalizedList.remove(normalizedList.size() - 1);
                continue;
            }
            normalizedList.add(o);
        }
        if (normalizedList.isEmpty()) {
            throw new ResourceKeyCreationException("Unable to build a valid key.");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(parentPrefix);
        for (int i = 0; i < normalizedList.size(); ++i) {
            String s = (String)normalizedList.get(i);
            if (i > 0) {
                buffer.append("/");
            }
            buffer.append(s);
        }
        return buffer.toString();
    }

    private static List parseName(String name, boolean skipLast) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer strTok = new StringTokenizer(name, "/");
        while (strTok.hasMoreElements()) {
            String s = (String)strTok.nextElement();
            if (s.length() == 0) continue;
            list.add(s);
        }
        if (skipLast && !list.isEmpty()) {
            list.remove(list.size() - 1);
        }
        return list;
    }

    public static String getFileName(String file) {
        int last = file.lastIndexOf("/");
        if (last < 0) {
            return file;
        }
        return file.substring(last + 1);
    }
}

