/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.resourceloader.loader.raw;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.jfree.resourceloader.ResourceData;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.ResourceLoadingException;
import org.jfree.resourceloader.ResourceManager;

public class RawResourceData
implements ResourceData {
    private ResourceKey rawKey;
    private byte[] data;

    public RawResourceData(ResourceKey rawKey) {
        if (rawKey == null) {
            throw new NullPointerException();
        }
        this.rawKey = rawKey;
        this.data = (byte[])rawKey.getIdentifier();
    }

    public byte[] getResource(ResourceManager caller) throws ResourceLoadingException {
        return (byte[])this.data.clone();
    }

    public InputStream getResourceAsStream(ResourceManager caller) throws ResourceLoadingException {
        return new ByteArrayInputStream(this.data);
    }

    public int getResource(ResourceManager caller, byte[] target, int offset, int length) throws ResourceLoadingException {
        if (offset > this.data.length) {
            return -1;
        }
        int remaining = this.data.length - offset;
        int maxReadable = Math.min(target.length, Math.min(remaining, length));
        System.arraycopy(this.data, offset, target, 0, maxReadable);
        return maxReadable;
    }

    public Object getAttribute(String key) {
        return null;
    }

    public ResourceKey getKey() {
        return this.rawKey;
    }

    public long getVersion(ResourceManager caller) throws ResourceLoadingException {
        return -1L;
    }
}

