/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.resourceloader.loader.zip;

import java.io.File;
import java.net.URL;
import org.jfree.resourceloader.ResourceData;
import org.jfree.resourceloader.ResourceKeyCreationException;
import org.jfree.resourceloader.ResourceLoadingException;
import org.jfree.resourceloader.ResourceManager;

public class ZipEntryKey {
    private ResourceData zipFile;
    private String entryName;

    public ZipEntryKey(ResourceData zipFile, String entryName) {
        if (zipFile == null) {
            throw new NullPointerException();
        }
        if (entryName == null) {
            throw new NullPointerException();
        }
        this.zipFile = zipFile;
        this.entryName = entryName;
    }

    public ZipEntryKey(ResourceManager manager, String zipFile, String entryName) throws ResourceKeyCreationException, ResourceLoadingException {
        if (zipFile == null) {
            throw new NullPointerException();
        }
        if (entryName == null) {
            throw new NullPointerException();
        }
        this.zipFile = manager.load(manager.createKey(zipFile));
        this.entryName = entryName;
    }

    public ZipEntryKey(ResourceManager manager, URL zipFile, String entryName) throws ResourceKeyCreationException, ResourceLoadingException {
        if (zipFile == null) {
            throw new NullPointerException();
        }
        if (entryName == null) {
            throw new NullPointerException();
        }
        this.zipFile = manager.load(manager.createKey(zipFile));
        this.entryName = entryName;
    }

    public ZipEntryKey(ResourceManager manager, File zipFile, String entryName) throws ResourceKeyCreationException, ResourceLoadingException {
        if (zipFile == null) {
            throw new NullPointerException();
        }
        if (entryName == null) {
            throw new NullPointerException();
        }
        this.zipFile = manager.load(manager.createKey(zipFile));
        this.entryName = entryName;
    }

    public ResourceData getZipFile() {
        return this.zipFile;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZipEntryKey that = (ZipEntryKey)o;
        if (!this.entryName.equals(that.entryName)) {
            return false;
        }
        return this.zipFile.getKey().equals(that.zipFile.getKey());
    }

    public int hashCode() {
        int result = this.zipFile.getKey().hashCode();
        result = 29 * result + this.entryName.hashCode();
        return result;
    }
}

