/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.resourceloader.modules.cache.ehcache;

import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import org.jfree.resourceloader.ResourceData;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.ResourceLoadingException;
import org.jfree.resourceloader.ResourceManager;
import org.jfree.resourceloader.cache.CachingResourceData;
import org.jfree.resourceloader.cache.DefaultResourceDataCacheEntry;
import org.jfree.resourceloader.cache.ResourceDataCache;
import org.jfree.resourceloader.cache.ResourceDataCacheEntry;

public class EHResourceDataCache
implements ResourceDataCache {
    private Cache dataCache;

    public EHResourceDataCache(Cache dataCache) {
        if (dataCache == null) {
            throw new NullPointerException();
        }
        this.dataCache = dataCache;
    }

    public ResourceDataCacheEntry get(ResourceKey key) {
        try {
            Element element = this.dataCache.get((Serializable)key);
            return (ResourceDataCacheEntry)element.getObjectValue();
        }
        catch (CacheException e) {
            return null;
        }
    }

    public ResourceData put(ResourceManager caller, ResourceData data) throws ResourceLoadingException {
        ResourceData cdata = CachingResourceData.createCached(data);
        this.dataCache.put(new Element((Serializable)data.getKey(), (Serializable)new DefaultResourceDataCacheEntry(cdata, caller)));
        return cdata;
    }

    public void remove(ResourceData data) {
        this.dataCache.remove((Serializable)data.getKey());
    }

    public void clear() {
        try {
            this.dataCache.removeAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

