/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.resourceloader.modules.cache.ehcache;

import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import org.jfree.resourceloader.Resource;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.cache.ResourceFactoryCache;

public class EHResourceFactoryCache
implements ResourceFactoryCache {
    private Cache factoryCache;

    public EHResourceFactoryCache(Cache factoryCache) {
        if (factoryCache == null) {
            throw new NullPointerException();
        }
        this.factoryCache = factoryCache;
    }

    public Resource get(ResourceKey key) {
        try {
            Element element = this.factoryCache.get((Serializable)key);
            return (Resource)element.getObjectValue();
        }
        catch (CacheException e) {
            return null;
        }
    }

    public void put(Resource resource) {
        ResourceKey source = resource.getSource();
        try {
            this.factoryCache.put(new Element((Serializable)source, (Serializable)resource));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void remove(Resource resource) {
        ResourceKey source = resource.getSource();
        this.factoryCache.remove((Serializable)source);
    }

    public void clear() {
        try {
            this.factoryCache.removeAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

