/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.resourceloader.modules.cache.oscache;

import com.opensymphony.oscache.base.NeedsRefreshException;
import com.opensymphony.oscache.general.GeneralCacheAdministrator;
import org.jfree.resourceloader.ResourceData;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.ResourceLoadingException;
import org.jfree.resourceloader.ResourceManager;
import org.jfree.resourceloader.cache.CacheUtility;
import org.jfree.resourceloader.cache.CachingResourceData;
import org.jfree.resourceloader.cache.DefaultResourceDataCacheEntry;
import org.jfree.resourceloader.cache.ResourceDataCache;
import org.jfree.resourceloader.cache.ResourceDataCacheEntry;

public class OSResourceDataCache
implements ResourceDataCache {
    private GeneralCacheAdministrator dataCache;

    public OSResourceDataCache(GeneralCacheAdministrator dataCache) {
        if (dataCache == null) {
            throw new NullPointerException();
        }
        this.dataCache = dataCache;
    }

    public ResourceDataCacheEntry get(ResourceKey key) {
        String ext = CacheUtility.externalizeKey(key);
        if (ext == null) {
            return null;
        }
        try {
            return (ResourceDataCacheEntry)this.dataCache.getFromCache(ext);
        }
        catch (NeedsRefreshException e) {
            this.dataCache.cancelUpdate(ext);
            this.dataCache.removeEntry(ext);
            return null;
        }
    }

    public ResourceData put(ResourceManager caller, ResourceData data) throws ResourceLoadingException {
        ResourceData cdata = CachingResourceData.createCached(data);
        String ext = CacheUtility.externalizeKey(data.getKey());
        if (ext == null) {
            return cdata;
        }
        this.dataCache.putInCache(ext, (Object)new DefaultResourceDataCacheEntry(cdata, caller));
        return cdata;
    }

    public void remove(ResourceData data) {
        String ext = CacheUtility.externalizeKey(data.getKey());
        if (ext == null) {
            return;
        }
        this.dataCache.removeEntry(ext);
    }

    public void clear() {
        this.dataCache.flushAll();
    }
}

