/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.resourceloader.modules.cache.oscache;

import com.opensymphony.oscache.base.NeedsRefreshException;
import com.opensymphony.oscache.general.GeneralCacheAdministrator;
import org.jfree.resourceloader.Resource;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.cache.CacheUtility;
import org.jfree.resourceloader.cache.ResourceFactoryCache;

public class OSResourceFactoryCache
implements ResourceFactoryCache {
    private GeneralCacheAdministrator factoryCache;

    public OSResourceFactoryCache(GeneralCacheAdministrator factoryCache) {
        if (factoryCache == null) {
            throw new NullPointerException();
        }
        this.factoryCache = factoryCache;
    }

    public Resource get(ResourceKey key) {
        String ext = CacheUtility.externalizeKey(key);
        if (ext == null) {
            return null;
        }
        try {
            return (Resource)this.factoryCache.getFromCache(ext);
        }
        catch (NeedsRefreshException e) {
            this.factoryCache.cancelUpdate(ext);
            this.factoryCache.removeEntry(ext);
            return null;
        }
    }

    public void put(Resource resource) {
        ResourceKey source = resource.getSource();
        String ext = CacheUtility.externalizeKey(source);
        if (ext == null) {
            return;
        }
        this.factoryCache.putInCache(ext, (Object)resource);
    }

    public void remove(Resource resource) {
        ResourceKey source = resource.getSource();
        String ext = CacheUtility.externalizeKey(source);
        if (ext == null) {
            return;
        }
        this.factoryCache.removeEntry(ext);
    }

    public void clear() {
        this.factoryCache.flushAll();
    }
}

