/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.data;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.jfree.report.DataSet;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportData;
import org.jfree.report.ReportDataFactory;
import org.jfree.report.ReportDataFactoryException;

public class CachingReportDataFactory
implements ReportDataFactory {
    private HashMap queryCache;
    private ReportDataFactory backend;

    public CachingReportDataFactory(ReportDataFactory backend) {
        if (backend == null) {
            throw new NullPointerException();
        }
        this.backend = backend;
        this.queryCache = new HashMap();
    }

    public void open() {
        this.backend.open();
    }

    public ReportData queryData(String query, DataSet parameters) throws ReportDataFactoryException {
        try {
            HashMap parameterCache = (HashMap)this.queryCache.get(query);
            if (parameterCache == null) {
                HashMap<Parameters, ReportData> newParams = new HashMap<Parameters, ReportData>();
                this.queryCache.put(query, newParams);
                Parameters params = new Parameters(parameters);
                ReportData newData = this.backend.queryData(query, params);
                newParams.put(params, newData);
                newData.setCursorPosition(0);
                return newData;
            }
            Parameters params = new Parameters(parameters);
            ReportData data = (ReportData)parameterCache.get(params);
            if (data != null) {
                data.setCursorPosition(0);
                return data;
            }
            ReportData newData = this.backend.queryData(query, params);
            parameterCache.put(params, newData);
            newData.setCursorPosition(0);
            return newData;
        }
        catch (DataSourceException e) {
            e.printStackTrace();
            throw new ReportDataFactoryException("Failed to query data", (Exception)((Object)e));
        }
    }

    public void close() {
        Iterator queries = this.queryCache.values().iterator();
        while (queries.hasNext()) {
            HashMap map = (HashMap)queries.next();
            Iterator dataSets = map.values().iterator();
            while (dataSets.hasNext()) {
                ReportData data = (ReportData)dataSets.next();
                try {
                    data.close();
                }
                catch (DataSourceException e) {}
            }
        }
        this.backend.close();
    }

    public ReportDataFactory derive() {
        throw new UnsupportedOperationException("The CachingReportDataFactory cannot be derived.");
    }

    private static class Parameters
    implements DataSet {
        private Object[] dataStore;
        private String[] nameStore;
        private Integer hashCode;

        protected Parameters(DataSet dataSet) throws DataSourceException {
            int columnCount = dataSet.getColumnCount();
            this.dataStore = new Object[columnCount];
            this.nameStore = new String[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                this.nameStore[i] = dataSet.getColumnName(i);
                this.dataStore[i] = dataSet.get(i);
            }
        }

        public int getColumnCount() throws DataSourceException {
            return this.dataStore.length;
        }

        public String getColumnName(int column) throws DataSourceException {
            return this.nameStore[column];
        }

        public Object get(int column) throws DataSourceException {
            return this.dataStore[column];
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Parameters that = (Parameters)o;
            if (!Arrays.equals(this.dataStore, that.dataStore)) {
                return false;
            }
            return Arrays.equals(this.nameStore, that.nameStore);
        }

        public synchronized int hashCode() {
            Object o;
            int i;
            if (this.hashCode != null) {
                return this.hashCode;
            }
            int hashCode = 0;
            for (i = 0; i < this.dataStore.length; ++i) {
                o = this.dataStore[i];
                if (o != null) {
                    hashCode = hashCode * 23 + o.hashCode();
                    continue;
                }
                hashCode *= 23;
            }
            for (i = 0; i < this.nameStore.length; ++i) {
                o = this.nameStore[i];
                if (o != null) {
                    hashCode = hashCode * 23 + o.hashCode();
                    continue;
                }
                hashCode *= 23;
            }
            this.hashCode = new Integer(hashCode);
            return hashCode;
        }
    }
}

