/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.data;

import java.util.HashMap;
import org.jfree.report.DataFlags;
import org.jfree.report.DataRow;
import org.jfree.report.DataSourceException;
import org.jfree.report.data.ExpressionSlot;
import org.jfree.report.data.GlobalMasterRow;
import org.jfree.report.data.MasterDataRowChangeEvent;
import org.jfree.report.flow.ReportContext;
import org.jfree.util.Log;

public final class ExpressionDataRow
implements DataRow {
    private ExpressionSlot[] expressions;
    private int length;
    private HashMap nameCache;
    private GlobalMasterRow masterRow;
    private ReportContext reportContext;

    public ExpressionDataRow(GlobalMasterRow masterRow, ReportContext reportContext, int capacity) {
        this.masterRow = masterRow;
        this.nameCache = new HashMap(capacity);
        this.expressions = new ExpressionSlot[capacity];
        this.reportContext = reportContext;
    }

    private ExpressionDataRow(GlobalMasterRow masterRow, ExpressionDataRow previousRow) throws CloneNotSupportedException {
        this.reportContext = previousRow.reportContext;
        this.masterRow = masterRow;
        this.nameCache = (HashMap)previousRow.nameCache.clone();
        this.expressions = new ExpressionSlot[previousRow.expressions.length];
        this.length = previousRow.length;
        for (int i = 0; i < this.length; ++i) {
            ExpressionSlot expression = previousRow.expressions[i];
            if (expression == null) {
                Log.debug((Object)"Error: Expression is null...");
                continue;
            }
            this.expressions[i] = (ExpressionSlot)expression.clone();
        }
    }

    private void ensureCapacity(int requestedSize) {
        int capacity = this.expressions.length;
        if (capacity > requestedSize) {
            return;
        }
        int newSize = Math.max(capacity * 2, requestedSize + 10);
        ExpressionSlot[] newExpressions = new ExpressionSlot[newSize];
        System.arraycopy(this.expressions, 0, newExpressions, 0, this.length);
        this.expressions = newExpressions;
    }

    public synchronized void pushExpression(ExpressionSlot expressionSlot) throws DataSourceException {
        if (expressionSlot == null) {
            throw new NullPointerException();
        }
        this.ensureCapacity(this.length + 1);
        this.expressions[this.length] = expressionSlot;
        String name = expressionSlot.getName();
        if (name != null) {
            this.nameCache.put(name, expressionSlot);
        }
        ++this.length;
        expressionSlot.updateDataRow(this.masterRow.getGlobalView());
        expressionSlot.advance();
        if (name != null) {
            Object value = expressionSlot.getValue();
            MasterDataRowChangeEvent chEvent = new MasterDataRowChangeEvent(1, name, value);
            this.masterRow.dataRowChanged(chEvent);
        }
    }

    public synchronized void pushExpressions(ExpressionSlot[] expressionSlots) throws DataSourceException {
        if (expressionSlots == null) {
            throw new NullPointerException();
        }
        this.ensureCapacity(this.length + expressionSlots.length);
        for (int i = 0; i < expressionSlots.length; ++i) {
            ExpressionSlot expression = expressionSlots[i];
            if (expression == null) continue;
            this.pushExpression(expression);
        }
    }

    public synchronized void popExpressions(int counter) throws DataSourceException {
        for (int i = 0; i < counter; ++i) {
            this.popExpression();
        }
    }

    public synchronized void popExpression() throws DataSourceException {
        if (this.length == 0) {
            return;
        }
        String originalName = this.expressions[this.length - 1].getName();
        boolean preserve = this.expressions[this.length - 1].isPreserve();
        this.expressions[this.length - 1] = null;
        --this.length;
        if (originalName != null) {
            int otherIndex = -1;
            for (int i = this.length - 1; i >= 0; --i) {
                ExpressionSlot expression = this.expressions[i];
                if (!originalName.equals(expression.getName())) continue;
                otherIndex = i;
                break;
            }
            if (otherIndex == -1) {
                this.nameCache.remove(originalName);
            } else {
                this.nameCache.put(originalName, this.expressions[otherIndex]);
            }
            if (!preserve) {
                MasterDataRowChangeEvent chEvent = new MasterDataRowChangeEvent(2, originalName, null);
                this.masterRow.dataRowChanged(chEvent);
            }
        }
    }

    public Object get(int col) throws DataSourceException {
        return this.expressions[col].getValue();
    }

    public Object get(String col) throws DataSourceException {
        ExpressionSlot es = (ExpressionSlot)this.nameCache.get(col);
        if (es == null) {
            return null;
        }
        return es.getValue();
    }

    public String getColumnName(int col) {
        return this.expressions[col].getName();
    }

    public int getColumnCount() {
        return this.length;
    }

    public DataFlags getFlags(String col) {
        throw new UnsupportedOperationException();
    }

    public DataFlags getFlags(int col) {
        throw new UnsupportedOperationException();
    }

    public ExpressionDataRow advance(GlobalMasterRow master, boolean deepTraversing) throws DataSourceException {
        try {
            ExpressionDataRow edr = new ExpressionDataRow(master, this);
            for (int i = edr.length - 1; i >= 0; --i) {
                ExpressionSlot expressionSlot = edr.expressions[i];
                expressionSlot.updateDataRow(master.getGlobalView());
                if (!deepTraversing || deepTraversing && expressionSlot.isDeepTraversing()) {
                    expressionSlot.advance();
                }
                Object value = expressionSlot.getValue();
                String name = expressionSlot.getName();
                if (name == null) continue;
                MasterDataRowChangeEvent chEvent = new MasterDataRowChangeEvent(3, name, value);
                master.dataRowChanged(chEvent);
            }
            return edr;
        }
        catch (CloneNotSupportedException e) {
            throw new DataSourceException("Cloning failed", e);
        }
    }

    public ExpressionDataRow derive(GlobalMasterRow master) throws DataSourceException {
        try {
            return new ExpressionDataRow(master, this);
        }
        catch (CloneNotSupportedException e) {
            throw new DataSourceException("Cloning failed", e);
        }
    }

    public ExpressionSlot[] getSlots() {
        ExpressionSlot[] slots = new ExpressionSlot[this.length];
        System.arraycopy(this.expressions, 0, slots, 0, this.length);
        return slots;
    }
}

