/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.data;

import org.jfree.report.DataRow;
import org.jfree.report.DataSourceException;
import org.jfree.report.data.GlobalMasterRow;
import org.jfree.report.data.StaticDataRow;
import org.jfree.report.flow.ParameterMapping;

public class ImportedVariablesDataRow
extends StaticDataRow {
    private String[] outerNames;
    private String[] innerNames;

    public ImportedVariablesDataRow(GlobalMasterRow innerRow) throws DataSourceException {
        DataRow globalView = innerRow.getGlobalView();
        int cols = globalView.getColumnCount();
        this.outerNames = new String[cols];
        this.innerNames = this.outerNames;
        Object[] values = new Object[this.outerNames.length];
        for (int i = 0; i < this.outerNames.length; ++i) {
            this.outerNames[i] = globalView.getColumnName(i);
            values[i] = globalView.get(i);
        }
        this.setData(this.outerNames, values);
    }

    public ImportedVariablesDataRow(GlobalMasterRow innerRow, ParameterMapping[] parameterMappings) throws DataSourceException {
        this.outerNames = new String[parameterMappings.length];
        this.innerNames = new String[parameterMappings.length];
        Object[] values = new Object[parameterMappings.length];
        DataRow globalView = innerRow.getGlobalView();
        for (int i = 0; i < parameterMappings.length; ++i) {
            ParameterMapping mapping = parameterMappings[i];
            String name = mapping.getAlias();
            values[i] = globalView.get(name);
            this.innerNames[i] = name;
            this.outerNames[i] = mapping.getName();
        }
        this.setData(this.outerNames, values);
    }

    protected ImportedVariablesDataRow(ImportedVariablesDataRow dataRow) {
        super(dataRow);
        this.outerNames = dataRow.outerNames;
        this.innerNames = dataRow.innerNames;
    }

    public ImportedVariablesDataRow advance(GlobalMasterRow innerRow) throws DataSourceException {
        DataRow globalView = innerRow.getGlobalView();
        Object[] values = new Object[this.outerNames.length];
        for (int i = 0; i < this.innerNames.length; ++i) {
            String name = this.innerNames[i];
            values[i] = globalView.get(name);
        }
        ImportedVariablesDataRow idr = new ImportedVariablesDataRow(this);
        idr.setData(this.outerNames, values);
        return idr;
    }
}

