/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.data;

import org.jfree.report.DataRow;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportData;
import org.jfree.report.data.ExpressionSlot;
import org.jfree.report.data.PrecomputeNode;
import org.jfree.report.data.StaticExpressionRuntimeData;
import org.jfree.report.expressions.Expression;
import org.jfree.report.expressions.ExpressionRuntime;
import org.jfree.report.expressions.Function;
import org.jfree.report.flow.ReportContext;
import org.jfree.report.i18n.ResourceBundleFactory;
import org.jfree.util.Configuration;

public class RunningExpressionSlot
implements ExpressionSlot,
ExpressionRuntime {
    private StaticExpressionRuntimeData staticRuntimeData;
    private Expression expression;
    private Object value;
    private String name;
    private boolean queried;
    private DataRow dataRow;

    public RunningExpressionSlot(Expression expression, StaticExpressionRuntimeData runtimeData, PrecomputeNode precomputeNode) {
        this.staticRuntimeData = runtimeData;
        this.expression = expression;
        this.name = expression.getName();
        this.expression.setRuntime(this);
        this.expression.setRuntime(null);
    }

    public Expression getExpression() {
        return this.expression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue() throws DataSourceException {
        if (!this.queried) {
            Expression expression = this.expression;
            synchronized (expression) {
                this.expression.setRuntime(this);
                this.value = this.expression.computeValue();
                this.expression.setRuntime(null);
            }
            this.queried = true;
        }
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public DataRow getDataRow() {
        return this.dataRow;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void updateDataRow(DataRow dataRow) {
        this.dataRow = dataRow;
    }

    public ReportData getData() {
        return this.staticRuntimeData.getData();
    }

    public Object getDeclaringParent() {
        return this.staticRuntimeData.getDeclaringParent();
    }

    public Configuration getConfiguration() {
        return this.staticRuntimeData.getConfiguration();
    }

    public ResourceBundleFactory getResourceBundleFactory() {
        return this.staticRuntimeData.getResourceBundleFactory();
    }

    public void advance() throws DataSourceException {
        if (this.expression instanceof Function) {
            Function f = (Function)this.expression;
            this.expression.setRuntime(this);
            this.expression = f.advance();
            f.setRuntime(null);
            this.expression.setRuntime(null);
        }
        this.value = null;
        this.queried = false;
    }

    public boolean isDeepTraversing() {
        return this.expression.isDeepTraversing();
    }

    public int getCurrentRow() {
        return this.staticRuntimeData.getCurrentRow();
    }

    public ReportContext getReportContext() {
        return this.staticRuntimeData.getReportContext();
    }

    public boolean isPreserve() {
        return this.expression.isPreserve();
    }
}

