/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.data;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jfree.report.DataFlags;
import org.jfree.report.DataRow;
import org.jfree.report.DataSourceException;
import org.jfree.report.data.DefaultDataFlags;
import org.jfree.report.util.IntegerCache;

public class StaticDataRow
implements DataRow {
    private String[] names;
    private Object[] values;
    private Map nameCache;

    protected StaticDataRow() {
    }

    protected StaticDataRow(StaticDataRow dataRow) {
        if (dataRow == null) {
            throw new NullPointerException();
        }
        this.nameCache = dataRow.nameCache;
        this.names = dataRow.names;
        this.values = dataRow.values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StaticDataRow(DataRow dataRow) throws DataSourceException {
        if (dataRow == null) {
            throw new NullPointerException();
        }
        HashMap<String, Integer> nameCache = new HashMap<String, Integer>();
        DataRow dataRow2 = dataRow;
        synchronized (dataRow2) {
            int columnCount = dataRow.getColumnCount();
            this.names = new String[columnCount];
            this.values = new Object[dataRow.getColumnCount()];
            for (int i = 0; i < columnCount; ++i) {
                this.names[i] = dataRow.getColumnName(i);
                this.values[i] = dataRow.get(i);
                if (this.names[i] == null) continue;
                nameCache.put(this.names[i], IntegerCache.getInteger(i));
            }
        }
        this.nameCache = Collections.unmodifiableMap(nameCache);
    }

    public StaticDataRow(String[] names, Object[] values) {
        this.setData(names, values);
    }

    protected void setData(String[] names, Object[] values) {
        if (names == null) {
            throw new NullPointerException();
        }
        if (values == null) {
            throw new NullPointerException();
        }
        if (names.length != values.length) {
            throw new IndexOutOfBoundsException();
        }
        this.names = (String[])names.clone();
        this.values = (Object[])values.clone();
        HashMap<String, Integer> nameCache = new HashMap<String, Integer>();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            if (name == null) continue;
            nameCache.put(name, IntegerCache.getInteger(i));
        }
        this.nameCache = Collections.unmodifiableMap(nameCache);
    }

    protected void updateData(Object[] values) {
        if (values.length != this.values.length) {
            throw new IllegalArgumentException("You should preserve the number of columns.");
        }
        this.values = (Object[])values.clone();
    }

    public Object get(int col) throws DataSourceException {
        return this.values[col];
    }

    public Object get(String col) throws DataSourceException {
        Integer idx = (Integer)this.nameCache.get(col);
        if (idx == null) {
            return null;
        }
        return this.values[idx];
    }

    public String getColumnName(int col) throws DataSourceException {
        return this.names[col];
    }

    public int getColumnCount() throws DataSourceException {
        return this.values.length;
    }

    public DataFlags getFlags(String col) throws DataSourceException {
        return new DefaultDataFlags(col, this.get(col), false);
    }

    public DataFlags getFlags(int col) throws DataSourceException {
        return new DefaultDataFlags(this.names[col], this.values[col], false);
    }
}

