/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.expressions;

import java.util.Locale;
import org.jfree.report.DataRow;
import org.jfree.report.expressions.Expression;
import org.jfree.report.expressions.ExpressionRuntime;
import org.jfree.report.flow.ReportContext;
import org.jfree.report.flow.ReportStructureRoot;
import org.jfree.report.i18n.ResourceBundleFactory;
import org.jfree.report.structure.Element;
import org.jfree.util.Configuration;

public abstract class AbstractExpression
implements Expression {
    private transient ExpressionRuntime runtime;
    private String name;
    private boolean deepTraversing;
    private boolean precompute;
    private boolean preserve;

    protected AbstractExpression() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object clone() throws CloneNotSupportedException {
        return (AbstractExpression)super.clone();
    }

    public Expression getInstance() {
        try {
            AbstractExpression abstractExpression = (AbstractExpression)this.clone();
            abstractExpression.runtime = null;
            return abstractExpression;
        }
        catch (CloneNotSupportedException cne) {
            return null;
        }
    }

    public void setRuntime(ExpressionRuntime runtime) {
        this.runtime = runtime;
    }

    public ExpressionRuntime getRuntime() {
        return this.runtime;
    }

    protected DataRow getDataRow() {
        if (this.runtime == null) {
            return null;
        }
        return this.runtime.getDataRow();
    }

    protected ResourceBundleFactory getResourceBundleFactory() {
        if (this.runtime == null) {
            return null;
        }
        return this.runtime.getResourceBundleFactory();
    }

    protected Configuration getReportConfiguration() {
        if (this.runtime == null) {
            return null;
        }
        return this.runtime.getConfiguration();
    }

    protected Locale getParentLocale() {
        if (this.runtime == null) {
            return null;
        }
        Object declaringParent = this.runtime.getDeclaringParent();
        if (declaringParent instanceof Element) {
            Element declaringElement = (Element)declaringParent;
            return declaringElement.getLocale();
        }
        ReportContext reportContext = this.runtime.getReportContext();
        ReportStructureRoot reportStructureRoot = reportContext.getReportStructureRoot();
        return reportStructureRoot.getLocale();
    }

    public boolean isPrecompute() {
        return this.precompute;
    }

    public void setPrecompute(boolean precompute) {
        this.precompute = precompute;
    }

    public boolean isDeepTraversing() {
        return this.deepTraversing;
    }

    public void setDeepTraversing(boolean deepTraversing) {
        this.deepTraversing = deepTraversing;
    }

    public boolean isPreserve() {
        return this.preserve;
    }

    public void setPreserve(boolean preserve) {
        this.preserve = preserve;
    }
}

