/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.expressions;

import org.jfree.formula.Formula;
import org.jfree.formula.FormulaContext;
import org.jfree.formula.parser.ParseException;
import org.jfree.report.DataSourceException;
import org.jfree.report.expressions.AbstractExpression;
import org.jfree.report.expressions.ReportFormulaContext;
import org.jfree.report.flow.ReportContext;
import org.jfree.util.Log;

public class FormulaExpression
extends AbstractExpression {
    private transient Formula compiledFormula;
    private String formulaNamespace;
    private String formulaExpression;
    private String formula;

    private synchronized FormulaContext getFormulaContext() {
        ReportContext globalContext = this.getRuntime().getReportContext();
        return globalContext.getFormulaContext();
    }

    public String getFormula() {
        return this.formula;
    }

    public String getFormulaNamespace() {
        return this.formulaNamespace;
    }

    public String getFormulaExpression() {
        return this.formulaExpression;
    }

    public void setFormula(String formula) {
        this.formula = formula;
        if (formula == null) {
            this.formulaNamespace = null;
            this.formulaExpression = null;
        } else {
            int separator = formula.indexOf(58);
            if (separator <= 0 || separator + 1 == formula.length()) {
                if (formula.startsWith("=")) {
                    this.formulaNamespace = "report";
                    this.formulaExpression = formula.substring(1);
                } else {
                    this.formulaNamespace = null;
                    this.formulaExpression = null;
                }
            } else {
                this.formulaNamespace = formula.substring(0, separator);
                this.formulaExpression = formula.substring(separator + 1);
            }
        }
        this.compiledFormula = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object computeRegularValue() {
        if (this.compiledFormula == null) {
            this.compiledFormula = new Formula(this.formulaExpression);
        }
        ReportFormulaContext context = new ReportFormulaContext(this.getFormulaContext(), this.getDataRow());
        try {
            this.compiledFormula.initialize((FormulaContext)context);
            Object object = this.compiledFormula.evaluate();
            context.setDataRow(null);
            return object;
        }
        catch (Throwable throwable) {
            try {
                context.setDataRow(null);
                throw throwable;
            }
            catch (Exception e) {
                Log.debug((Object)"Failed to compute the regular value.", (Exception)e);
                return null;
            }
        }
    }

    public Formula getCompiledFormula() throws ParseException {
        if (this.compiledFormula == null) {
            this.compiledFormula = new Formula(this.formulaExpression);
        }
        return this.compiledFormula;
    }

    public Object computeValue() throws DataSourceException {
        try {
            return this.computeRegularValue();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        FormulaExpression o = (FormulaExpression)super.clone();
        if (this.compiledFormula != null) {
            o.compiledFormula = (Formula)this.compiledFormula.clone();
        }
        return o;
    }
}

