/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.expressions;

import org.jfree.formula.Formula;
import org.jfree.formula.FormulaContext;
import org.jfree.formula.parser.ParseException;
import org.jfree.report.DataSourceException;
import org.jfree.report.expressions.AbstractExpression;
import org.jfree.report.expressions.Function;
import org.jfree.report.expressions.ReportFormulaContext;
import org.jfree.report.flow.ReportContext;
import org.jfree.util.Log;

public class FormulaFunction
extends AbstractExpression
implements Function {
    private String formulaNamespace;
    private String formulaExpression;
    private String formula;
    private String initialNamespace;
    private String initialExpression;
    private String initial;
    private transient Formula compiledFormula;
    private boolean initialized;

    private synchronized FormulaContext getFormulaContext() {
        ReportContext globalContext = this.getRuntime().getReportContext();
        return globalContext.getFormulaContext();
    }

    public String getInitial() {
        return this.initial;
    }

    public String getInitialExpression() {
        return this.initialExpression;
    }

    public String getInitialNamespace() {
        return this.initialNamespace;
    }

    public void setInitial(String initial) {
        this.initial = initial;
        if (initial == null) {
            this.initialNamespace = null;
            this.initialExpression = null;
        } else {
            int separator = initial.indexOf(58);
            if (separator <= 0 || separator + 1 == initial.length()) {
                if (this.formula.startsWith("=")) {
                    this.initialNamespace = "report";
                    this.initialExpression = initial.substring(1);
                } else {
                    this.initialNamespace = null;
                    this.initialExpression = null;
                }
            } else {
                this.initialNamespace = initial.substring(0, separator);
                this.initialExpression = initial.substring(separator + 1);
            }
        }
    }

    public String getFormula() {
        return this.formula;
    }

    public String getFormulaNamespace() {
        return this.formulaNamespace;
    }

    public String getFormulaExpression() {
        return this.formulaExpression;
    }

    public void setFormula(String formula) {
        this.formula = formula;
        if (formula == null) {
            this.formulaNamespace = null;
            this.formulaExpression = null;
        } else {
            int separator = formula.indexOf(58);
            if (separator <= 0 || separator + 1 == formula.length()) {
                if (formula.startsWith("=")) {
                    this.formulaNamespace = "report";
                    this.formulaExpression = formula.substring(1);
                } else {
                    this.formulaNamespace = null;
                    this.formulaExpression = null;
                }
            } else {
                this.formulaNamespace = formula.substring(0, separator);
                this.formulaExpression = formula.substring(separator + 1);
            }
        }
        this.compiledFormula = null;
    }

    public Function advance() throws DataSourceException {
        try {
            return (Function)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new DataSourceException("Unable to derive a new instance");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object computeInitialValue() {
        if (this.initial == null) return this.computeRegularValue();
        Formula initFormula = new Formula(this.initialExpression);
        ReportFormulaContext context = new ReportFormulaContext(this.getFormulaContext(), this.getDataRow());
        context.setDeclaringElement(this.getRuntime().getDeclaringParent());
        try {
            initFormula.initialize((FormulaContext)context);
            Object object = initFormula.evaluate();
            context.setDeclaringElement(null);
            context.setDataRow(null);
            return object;
        }
        catch (Throwable throwable) {
            try {
                context.setDeclaringElement(null);
                context.setDataRow(null);
                throw throwable;
            }
            catch (Exception e) {
                Log.debug((Object)"Failed to compute the initial value.");
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object computeRegularValue() {
        if (this.compiledFormula == null) {
            this.compiledFormula = new Formula(this.formulaExpression);
        }
        ReportFormulaContext context = new ReportFormulaContext(this.getFormulaContext(), this.getDataRow());
        context.setDeclaringElement(this.getRuntime().getDeclaringParent());
        try {
            this.compiledFormula.initialize((FormulaContext)context);
            Object object = this.compiledFormula.evaluate();
            context.setDeclaringElement(null);
            context.setDataRow(null);
            return object;
        }
        catch (Throwable throwable) {
            try {
                context.setDeclaringElement(null);
                context.setDataRow(null);
                throw throwable;
            }
            catch (Exception e) {
                Log.debug((Object)"Failed to compute the regular value.", (Exception)e);
                return null;
            }
        }
    }

    public Object computeValue() throws DataSourceException {
        try {
            if (!this.initialized) {
                this.initialized = true;
                return this.computeInitialValue();
            }
            return this.computeRegularValue();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        FormulaFunction o = (FormulaFunction)super.clone();
        if (this.compiledFormula != null) {
            o.compiledFormula = (Formula)this.compiledFormula.clone();
        }
        return o;
    }

    public Formula getCompiledFormula() throws ParseException {
        if (this.compiledFormula == null) {
            this.compiledFormula = new Formula(this.formulaExpression);
        }
        return this.compiledFormula;
    }
}

