/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.flow;

import org.jfree.formula.DefaultFormulaContext;
import org.jfree.formula.FormulaContext;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportDataFactoryException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.data.ReportContextImpl;
import org.jfree.report.flow.DefaultFlowController;
import org.jfree.report.flow.FlowController;
import org.jfree.report.flow.ReportContext;
import org.jfree.report.flow.ReportJob;
import org.jfree.report.flow.ReportProcessor;
import org.jfree.report.flow.ReportTarget;
import org.jfree.report.flow.layoutprocessor.DefaultLayoutControllerFactory;
import org.jfree.report.flow.layoutprocessor.LayoutController;
import org.jfree.report.flow.layoutprocessor.LayoutControllerFactory;

public abstract class AbstractReportProcessor
implements ReportProcessor {
    protected AbstractReportProcessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processReportRun(ReportJob job, ReportTarget target) throws ReportDataFactoryException, DataSourceException, ReportProcessingException {
        ReportJob reportJob = job;
        synchronized (reportJob) {
            ReportContext context = this.createReportContext(job, target);
            LayoutControllerFactory layoutFactory = context.getLayoutControllerFactory();
            FlowController flowController = this.createFlowControler(context, job);
            LayoutController layoutController = layoutFactory.create(flowController, job.getReportStructureRoot(), null);
            while (layoutController.isAdvanceable()) {
                layoutController = layoutController.advance(target);
                while (!layoutController.isAdvanceable() && layoutController.getParent() != null) {
                    LayoutController parent = layoutController.getParent();
                    target.commit();
                    layoutController = parent.join(layoutController.getFlowController());
                }
            }
            target.commit();
        }
    }

    protected ReportContext createReportContext(ReportJob job, ReportTarget target) {
        ReportContextImpl context = new ReportContextImpl();
        context.setExportDescriptor(target.getExportDescriptor());
        DefaultLayoutControllerFactory lcf = new DefaultLayoutControllerFactory();
        lcf.initialize(job);
        context.setLayoutControllerFactory(lcf);
        DefaultFormulaContext formulaContext = new DefaultFormulaContext();
        context.setFormulaContext((FormulaContext)formulaContext);
        context.setResourceBundleFactory(job.getResourceBundleFactory());
        context.setReportStructureRoot(job.getReportStructureRoot());
        return context;
    }

    protected FlowController createFlowControler(ReportContext context, ReportJob job) throws DataSourceException {
        return new DefaultFlowController(context, job);
    }
}

