/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.flow;

import org.jfree.layouting.namespace.NamespaceDefinition;
import org.jfree.layouting.namespace.Namespaces;
import org.jfree.report.flow.ReportJob;
import org.jfree.report.flow.ReportTarget;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.ResourceManager;
import org.jfree.util.Configuration;

public abstract class AbstractReportTarget
implements ReportTarget {
    private ResourceManager resourceManager;
    private ResourceKey baseResource;
    private ReportJob reportJob;

    protected AbstractReportTarget(ReportJob reportJob, ResourceManager resourceManager, ResourceKey baseResource) {
        if (reportJob == null) {
            throw new NullPointerException();
        }
        this.baseResource = baseResource;
        this.reportJob = reportJob;
        if (resourceManager == null) {
            this.resourceManager = new ResourceManager();
            this.resourceManager.registerDefaults();
        } else {
            this.resourceManager = resourceManager;
        }
    }

    protected NamespaceDefinition[] createDefaultNameSpaces() {
        return Namespaces.createFromConfig((Configuration)this.reportJob.getConfiguration(), (String)"org.jfree.report.namespaces.", (ResourceManager)this.getResourceManager());
    }

    protected ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    protected ResourceKey getBaseResource() {
        return this.baseResource;
    }

    public ReportJob getReportJob() {
        return this.reportJob;
    }
}

