/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.flow;

import org.jfree.report.DataSourceException;
import org.jfree.report.ReportDataFactoryException;
import org.jfree.report.data.CachingReportDataFactory;
import org.jfree.report.data.ExpressionDataRow;
import org.jfree.report.data.ExpressionSlot;
import org.jfree.report.data.GlobalMasterRow;
import org.jfree.report.data.ImportedVariablesDataRow;
import org.jfree.report.data.ParameterDataRow;
import org.jfree.report.data.PrecomputedValueRegistry;
import org.jfree.report.data.PrecomputedValueRegistryBuilder;
import org.jfree.report.data.ReportDataRow;
import org.jfree.report.flow.FlowControlOperation;
import org.jfree.report.flow.FlowController;
import org.jfree.report.flow.ParameterMapping;
import org.jfree.report.flow.ReportContext;
import org.jfree.report.flow.ReportJob;
import org.jfree.report.util.IntegerCache;
import org.jfree.util.FastStack;

public class DefaultFlowController
implements FlowController {
    private CachingReportDataFactory reportDataFactory;
    private GlobalMasterRow dataRow;
    private boolean advanceRequested;
    private FastStack reportStack;
    private FastStack markStack;
    private FastStack expressionsStack;
    private String exportDescriptor;
    private ReportContext reportContext;
    private ReportJob job;
    private PrecomputedValueRegistry precomputedValueRegistry;

    public DefaultFlowController(ReportContext reportContext, ReportJob job) throws DataSourceException {
        if (job == null) {
            throw new NullPointerException();
        }
        if (reportContext == null) {
            throw new NullPointerException();
        }
        this.reportContext = reportContext;
        this.job = job;
        this.exportDescriptor = reportContext.getExportDescriptor();
        this.reportDataFactory = new CachingReportDataFactory(job.getDataFactory());
        this.reportStack = new FastStack();
        this.markStack = new FastStack();
        this.expressionsStack = new FastStack();
        this.advanceRequested = false;
        this.dataRow = GlobalMasterRow.createReportRow(reportContext);
        this.dataRow.setParameterDataRow(new ParameterDataRow(job.getParameters()));
        this.precomputedValueRegistry = new PrecomputedValueRegistryBuilder();
    }

    protected DefaultFlowController(DefaultFlowController fc, GlobalMasterRow dataRow) {
        this.reportContext = fc.reportContext;
        this.job = fc.job;
        this.exportDescriptor = fc.exportDescriptor;
        this.reportDataFactory = fc.reportDataFactory;
        this.reportStack = (FastStack)fc.reportStack.clone();
        this.markStack = (FastStack)fc.markStack.clone();
        this.expressionsStack = (FastStack)fc.expressionsStack.clone();
        this.advanceRequested = fc.advanceRequested;
        this.dataRow = dataRow;
        this.precomputedValueRegistry = fc.precomputedValueRegistry;
    }

    public FlowController performOperation(FlowControlOperation operation) throws DataSourceException {
        if (operation == FlowControlOperation.ADVANCE) {
            if (this.dataRow.isAdvanceable() && !this.advanceRequested) {
                DefaultFlowController fc = new DefaultFlowController(this, this.dataRow);
                fc.advanceRequested = true;
                return fc;
            }
        } else {
            if (operation == FlowControlOperation.MARK) {
                DefaultFlowController fc = new DefaultFlowController(this, this.dataRow);
                fc.markStack.push((Object)this.dataRow);
                return fc;
            }
            if (operation == FlowControlOperation.RECALL) {
                if (this.markStack.isEmpty()) {
                    return this;
                }
                DefaultFlowController fc = new DefaultFlowController(this, this.dataRow);
                fc.dataRow = (GlobalMasterRow)fc.markStack.pop();
                fc.advanceRequested = false;
                return fc;
            }
            if (operation == FlowControlOperation.DONE) {
                DefaultFlowController fc = new DefaultFlowController(this, this.dataRow);
                fc.markStack.pop();
                return fc;
            }
            if (operation == FlowControlOperation.COMMIT && this.isAdvanceRequested()) {
                DefaultFlowController fc = new DefaultFlowController(this, this.dataRow);
                fc.dataRow = this.dataRow.advance();
                fc.advanceRequested = false;
                return fc;
            }
        }
        return this;
    }

    public GlobalMasterRow getMasterRow() {
        return this.dataRow;
    }

    public boolean isAdvanceRequested() {
        return this.advanceRequested;
    }

    public FlowController performQuery(String query) throws ReportDataFactoryException, DataSourceException {
        GlobalMasterRow masterRow = GlobalMasterRow.createReportRow(this.dataRow, this.reportContext);
        masterRow.setParameterDataRow(new ParameterDataRow(this.getReportJob().getParameters()));
        masterRow.setReportDataRow(ReportDataRow.createDataRow(this.reportDataFactory, query, this.dataRow.getGlobalView()));
        DefaultFlowController fc = new DefaultFlowController(this, masterRow);
        fc.reportStack.push((Object)new ReportDataContext(fc.markStack, this.advanceRequested));
        fc.markStack = new FastStack();
        fc.dataRow = masterRow;
        return fc;
    }

    public FlowController performSubReportQuery(String query, ParameterMapping[] inputParameters, ParameterMapping[] outputParameters) throws ReportDataFactoryException, DataSourceException {
        GlobalMasterRow outerRow = this.dataRow.derive();
        GlobalMasterRow masterRow = GlobalMasterRow.createReportRow(outerRow, this.reportContext);
        masterRow.setParameterDataRow(new ParameterDataRow(inputParameters, outerRow.getGlobalView()));
        masterRow.setReportDataRow(ReportDataRow.createDataRow(this.reportDataFactory, query, masterRow.getGlobalView()));
        if (outputParameters == null) {
            outerRow.setExportedDataRow(new ImportedVariablesDataRow(masterRow));
        } else {
            outerRow.setExportedDataRow(new ImportedVariablesDataRow(masterRow, outputParameters));
        }
        DefaultFlowController fc = new DefaultFlowController(this, masterRow);
        fc.reportStack.push((Object)new ReportDataContext(fc.markStack, this.advanceRequested));
        fc.markStack = new FastStack();
        fc.dataRow = masterRow;
        return fc;
    }

    public FlowController activateExpressions(ExpressionSlot[] expressions) throws DataSourceException {
        if (expressions.length == 0) {
            DefaultFlowController fc = new DefaultFlowController(this, this.dataRow);
            fc.expressionsStack.push((Object)IntegerCache.getInteger(0));
            return fc;
        }
        GlobalMasterRow dataRow = this.dataRow.derive();
        ExpressionDataRow edr = dataRow.getExpressionDataRow();
        edr.pushExpressions(expressions);
        DefaultFlowController fc = new DefaultFlowController(this, dataRow);
        Integer exCount = IntegerCache.getInteger(expressions.length);
        fc.expressionsStack.push((Object)exCount);
        return fc;
    }

    public FlowController deactivateExpressions() throws DataSourceException {
        Integer counter = (Integer)this.expressionsStack.peek();
        int counterRaw = counter;
        if (counterRaw == 0) {
            DefaultFlowController fc = new DefaultFlowController(this, this.dataRow);
            fc.expressionsStack.pop();
            return fc;
        }
        GlobalMasterRow dataRow = this.dataRow.derive();
        ExpressionDataRow edr = dataRow.getExpressionDataRow();
        DefaultFlowController fc = new DefaultFlowController(this, dataRow);
        fc.expressionsStack.pop();
        edr.popExpressions(counterRaw);
        return fc;
    }

    public FlowController performReturnFromQuery() throws DataSourceException {
        DefaultFlowController fc = new DefaultFlowController(this, this.dataRow);
        ReportDataRow reportDataRow = this.dataRow.getReportDataRow();
        if (reportDataRow == null) {
            return this;
        }
        ReportDataContext context = (ReportDataContext)fc.reportStack.pop();
        fc.dataRow = this.dataRow.getParentDataRow();
        fc.dataRow = fc.dataRow.derive();
        fc.dataRow.setExportedDataRow(null);
        fc.markStack = context.getMarkStack();
        fc.advanceRequested = context.isAdvanceRequested();
        return fc;
    }

    public ReportJob getReportJob() {
        return this.job;
    }

    public String getExportDescriptor() {
        return this.exportDescriptor;
    }

    public ReportContext getReportContext() {
        return this.reportContext;
    }

    public ExpressionSlot[] getActiveExpressions() throws DataSourceException {
        return this.dataRow.getExpressionDataRow().getSlots();
    }

    public FlowController createPrecomputeInstance() throws DataSourceException {
        DefaultFlowController precompute = new DefaultFlowController(this, this.dataRow.derive());
        precompute.precomputedValueRegistry = new PrecomputedValueRegistryBuilder();
        return precompute;
    }

    public PrecomputedValueRegistry getPrecomputedValueRegistry() {
        return this.precomputedValueRegistry;
    }

    private static class ReportDataContext {
        private FastStack markStack;
        private boolean advanceRequested;

        public ReportDataContext(FastStack markStack, boolean advanceRequested) {
            this.advanceRequested = advanceRequested;
            this.markStack = markStack;
        }

        public boolean isAdvanceRequested() {
            return this.advanceRequested;
        }

        public FastStack getMarkStack() {
            return this.markStack;
        }
    }
}

