/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.flow;

import org.jfree.base.config.HierarchicalConfiguration;
import org.jfree.base.config.ModifiableConfiguration;
import org.jfree.report.ReportDataFactory;
import org.jfree.report.flow.ReportJob;
import org.jfree.report.flow.ReportStructureRoot;
import org.jfree.report.i18n.DefaultResourceBundleFactory;
import org.jfree.report.i18n.ResourceBundleFactory;
import org.jfree.report.util.ReportParameters;

public class DefaultReportJob
implements ReportJob {
    private ReportStructureRoot report;
    private ReportDataFactory dataFactory;
    private ReportParameters parameters;
    private ModifiableConfiguration configuration;
    private ResourceBundleFactory resourceBundleFactory = new DefaultResourceBundleFactory();
    private String name;

    public DefaultReportJob(ReportStructureRoot report) {
        this.report = report;
        ReportDataFactory dataFactory = report.getDataFactory();
        if (dataFactory != null) {
            this.dataFactory = dataFactory.derive();
        }
        this.parameters = new ReportParameters(report.getInputParameters());
        this.configuration = new HierarchicalConfiguration(report.getConfiguration());
    }

    public ModifiableConfiguration getConfiguration() {
        return this.configuration;
    }

    public ReportParameters getParameters() {
        return this.parameters;
    }

    public ReportStructureRoot getReportStructureRoot() {
        return this.report;
    }

    public ReportDataFactory getDataFactory() {
        return this.dataFactory;
    }

    public void setDataFactory(ReportDataFactory dataFactory) {
        this.dataFactory = dataFactory;
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultReportJob job = (DefaultReportJob)super.clone();
        if (this.dataFactory != null) {
            job.dataFactory = this.dataFactory.derive();
        }
        job.parameters = (ReportParameters)this.parameters.clone();
        job.configuration = (ModifiableConfiguration)this.configuration.clone();
        return job;
    }

    public ReportJob derive() {
        try {
            return (ReportJob)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("A report job should always be cloneable.");
        }
    }

    public synchronized void close() {
        if (this.dataFactory != null) {
            this.dataFactory.close();
        }
    }

    public ResourceBundleFactory getResourceBundleFactory() {
        return this.resourceBundleFactory;
    }

    public void setResourceBundleFactory(ResourceBundleFactory resourceBundleFactory) {
        this.resourceBundleFactory = resourceBundleFactory;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

