/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.flow.layoutprocessor;

import org.jfree.report.DataSourceException;
import org.jfree.report.ReportDataFactoryException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.flow.FlowController;
import org.jfree.report.flow.ReportTarget;
import org.jfree.report.flow.layoutprocessor.AbstractLayoutController;
import org.jfree.report.flow.layoutprocessor.BufferedReportTarget;
import org.jfree.report.flow.layoutprocessor.LayoutController;

public abstract class BufferingLayoutController
extends AbstractLayoutController {
    private BufferedReportTarget reportTarget = new BufferedReportTarget();
    private LayoutController delegate;
    private boolean finished;

    protected BufferingLayoutController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LayoutController advance(ReportTarget target) throws DataSourceException, ReportDataFactoryException, ReportProcessingException {
        this.reportTarget.setTarget(target);
        if (this.delegate != null) {
            try {
                BufferingLayoutController bc = (BufferingLayoutController)this.clone();
                bc.delegate = this.delegate.advance(this.reportTarget);
                BufferingLayoutController bufferingLayoutController = bc;
                return bufferingLayoutController;
            }
            finally {
                this.reportTarget.setTarget(null);
            }
        }
        this.reportTarget.close(target);
        if (this.getParent() == null) {
            BufferingLayoutController bc = (BufferingLayoutController)this.clone();
            bc.finished = true;
            return bc;
        }
        return this.joinWithParent();
    }

    protected LayoutController joinWithParent() throws ReportProcessingException, ReportDataFactoryException, DataSourceException {
        LayoutController parent = this.getParent();
        if (parent == null) {
            throw new IllegalStateException("There is no parent to join with. This should not happen in a sane environment!");
        }
        return parent.join(this.getFlowController());
    }

    public void initialize(Object node, FlowController flowController, LayoutController parent) throws DataSourceException, ReportDataFactoryException, ReportProcessingException {
        super.initialize(node, flowController, parent);
        this.delegate = this.getInitialDelegate();
    }

    protected abstract LayoutController getInitialDelegate();

    public boolean isAdvanceable() {
        if (this.delegate == null) {
            return !this.finished;
        }
        return this.delegate.isAdvanceable();
    }

    public LayoutController join(FlowController flowController) throws ReportProcessingException, DataSourceException {
        BufferingLayoutController bc = (BufferingLayoutController)this.clone();
        bc.delegate = null;
        return bc;
    }

    public Object clone() {
        BufferingLayoutController o = (BufferingLayoutController)super.clone();
        o.reportTarget = (BufferedReportTarget)this.reportTarget.clone();
        return o;
    }
}

