/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.flow.layoutprocessor;

import org.jfree.report.DataSourceException;
import org.jfree.report.ReportDataFactoryException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.expressions.Expression;
import org.jfree.report.flow.FlowController;
import org.jfree.report.flow.ReportContext;
import org.jfree.report.flow.ReportTarget;
import org.jfree.report.flow.layoutprocessor.ElementLayoutController;
import org.jfree.report.flow.layoutprocessor.LayoutController;
import org.jfree.report.flow.layoutprocessor.LayoutControllerFactory;
import org.jfree.report.flow.layoutprocessor.LayoutControllerUtil;
import org.jfree.report.structure.Node;
import org.jfree.report.structure.Section;

public class SectionLayoutController
extends ElementLayoutController {
    private Node[] nodes;
    private int index;

    protected FlowController startData(ReportTarget target, FlowController fc) throws DataSourceException, ReportProcessingException, ReportDataFactoryException {
        Section s = (Section)this.getElement();
        return LayoutControllerUtil.processFlowOperations(fc, s.getOperationBefore());
    }

    protected LayoutController processContent(ReportTarget target) throws DataSourceException, ReportProcessingException, ReportDataFactoryException {
        FlowController flowController = this.getFlowController();
        Node[] nodes = this.getNodes();
        int currentIndex = this.getIndex();
        if (currentIndex < nodes.length) {
            Node node = nodes[currentIndex];
            SectionLayoutController derived = (SectionLayoutController)this.clone();
            return this.processChild(derived, node, flowController);
        }
        SectionLayoutController derived = (SectionLayoutController)this.clone();
        derived.setProcessingState(3);
        return derived;
    }

    protected LayoutController processChild(SectionLayoutController derived, Node node, FlowController flowController) throws DataSourceException, ReportProcessingException, ReportDataFactoryException {
        ReportContext reportContext = flowController.getReportContext();
        LayoutControllerFactory layoutControllerFactory = reportContext.getLayoutControllerFactory();
        if (this.isDisplayable(node)) {
            derived.setProcessingState(2);
            return layoutControllerFactory.create(flowController, node, derived);
        }
        derived.setProcessingState(2);
        LayoutController childLc = layoutControllerFactory.create(flowController, node, derived);
        return LayoutControllerUtil.skipInvisibleElement(childLc);
    }

    private boolean isDisplayable(Node node) throws DataSourceException {
        if (!node.isEnabled()) {
            return false;
        }
        Expression expression = node.getDisplayCondition();
        if (expression == null) {
            return true;
        }
        Object result = LayoutControllerUtil.evaluateExpression(this.getFlowController(), node, expression);
        return Boolean.TRUE.equals(result);
    }

    protected LayoutController finishElement(ReportTarget target) throws ReportProcessingException, DataSourceException, ReportDataFactoryException {
        FlowController cfc;
        FlowController fc = this.handleDefaultEndElement(target);
        Section s = (Section)this.getElement();
        fc = this.finishData(target, fc);
        if (s.isRepeat() && (cfc = this.tryRepeatingCommit(fc)) != null) {
            SectionLayoutController derived = (SectionLayoutController)this.clone();
            derived.setProcessingState(0);
            derived.setFlowController(cfc);
            derived.resetSectionForRepeat();
            return derived;
        }
        SectionLayoutController derived = (SectionLayoutController)this.clone();
        derived.setProcessingState(4);
        derived.setFlowController(fc);
        return derived;
    }

    protected void resetSectionForRepeat() {
        this.setIndex(0);
    }

    protected FlowController finishData(ReportTarget target, FlowController fc) throws DataSourceException, ReportProcessingException {
        Section s = (Section)this.getElement();
        return LayoutControllerUtil.processFlowOperations(fc, s.getOperationAfter());
    }

    public LayoutController join(FlowController flowController) {
        SectionLayoutController derived;
        Node node;
        int index;
        Node[] nodes = this.getNodes();
        for (index = this.getIndex() + 1; index < nodes.length && !(node = nodes[index]).isEnabled(); ++index) {
        }
        if (index < nodes.length) {
            derived = (SectionLayoutController)this.clone();
            derived.setProcessingState(1);
            derived.setFlowController(flowController);
            derived.setIndex(index);
            return derived;
        }
        derived = (SectionLayoutController)this.clone();
        derived.setProcessingState(3);
        derived.setFlowController(flowController);
        return derived;
    }

    public Node[] getNodes() {
        if (this.nodes == null) {
            Section s = (Section)this.getElement();
            this.nodes = s.getNodeArray();
        }
        return this.nodes;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

