/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.factories.data.sql;

import java.util.ArrayList;
import org.jfree.report.ReportDataFactory;
import org.jfree.report.modules.data.sql.ConnectionProvider;
import org.jfree.report.modules.data.sql.SQLReportDataFactory;
import org.jfree.report.modules.factories.data.base.DataFactoryReadHandler;
import org.jfree.report.modules.factories.data.sql.ConfigReadHandler;
import org.jfree.report.modules.factories.data.sql.ConnectionReadHandler;
import org.jfree.report.modules.factories.data.sql.ConnectionReadHandlerFactory;
import org.jfree.xmlns.parser.AbstractXmlReadHandler;
import org.jfree.xmlns.parser.ParseException;
import org.jfree.xmlns.parser.PropertyReadHandler;
import org.jfree.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SQLDataFactoryReadHandler
extends AbstractXmlReadHandler
implements DataFactoryReadHandler {
    private ConnectionReadHandler connectionProviderReadHandler;
    private ArrayList queries = new ArrayList();
    private ConfigReadHandler configReadHandler;
    private ReportDataFactory dataFactory;

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        ConnectionReadHandlerFactory factory = ConnectionReadHandlerFactory.getInstance();
        ConnectionReadHandler handler = (ConnectionReadHandler)factory.getHandler(uri, tagName);
        if (handler != null) {
            this.connectionProviderReadHandler = handler;
            return this.connectionProviderReadHandler;
        }
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if (tagName.equals("config")) {
            this.configReadHandler = new ConfigReadHandler();
            return this.configReadHandler;
        }
        if (tagName.equals("query")) {
            PropertyReadHandler queryReadHandler = new PropertyReadHandler();
            this.queries.add(queryReadHandler);
            return queryReadHandler;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        Boolean labelMapping;
        ConnectionProvider provider = null;
        if (this.connectionProviderReadHandler != null) {
            provider = this.connectionProviderReadHandler.getProvider();
        }
        if (provider == null) {
            provider = (ConnectionProvider)this.getRootHandler().getHelperObject("connection-provider");
        }
        if (provider == null) {
            throw new ParseException("Unable to create SQL Factory: No connection provider.", this.getLocator());
        }
        SQLReportDataFactory srdf = new SQLReportDataFactory(provider);
        if (this.configReadHandler != null && (labelMapping = this.configReadHandler.isLabelMapping()) != null) {
            srdf.setLabelMapping(labelMapping);
        }
        for (int i = 0; i < this.queries.size(); ++i) {
            PropertyReadHandler handler = (PropertyReadHandler)this.queries.get(i);
            srdf.setQuery(handler.getName(), handler.getResult());
        }
        this.dataFactory = srdf;
    }

    public Object getObject() throws SAXException {
        return this.dataFactory;
    }

    public ReportDataFactory getDataFactory() {
        return this.dataFactory;
    }
}

