/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.factories.report.flow;

import java.util.ArrayList;
import org.jfree.report.modules.factories.report.base.NodeReadHandler;
import org.jfree.report.modules.factories.report.flow.AbstractExpressionReadHandler;
import org.jfree.report.modules.factories.report.flow.AttributeExpressionReadHandler;
import org.jfree.report.modules.factories.report.flow.AttributeReadHandler;
import org.jfree.report.modules.factories.report.flow.DisplayConditionReadHandler;
import org.jfree.report.modules.factories.report.flow.ExpressionReadHandler;
import org.jfree.report.modules.factories.report.flow.StyleExpressionReadHandler;
import org.jfree.report.structure.Element;
import org.jfree.report.structure.Node;
import org.jfree.xmlns.parser.AbstractXmlReadHandler;
import org.jfree.xmlns.parser.PropertyReadHandler;
import org.jfree.xmlns.parser.RootXmlReadHandler;
import org.jfree.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class AbstractElementReadHandler
extends AbstractXmlReadHandler
implements NodeReadHandler {
    private boolean virtual;
    private boolean enabled;
    private String style;
    private ArrayList expressionHandlers = new ArrayList();
    private ArrayList styleExpressionHandlers = new ArrayList();
    private ArrayList attributeExpressionHandlers = new ArrayList();
    private ArrayList attributeHandlers;
    private ArrayList stylePropertyHandlers = new ArrayList();
    private DisplayConditionReadHandler displayConditionReadHandler;

    protected AbstractElementReadHandler() {
        this.attributeHandlers = new ArrayList();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getStyle() {
        return this.style;
    }

    public void init(RootXmlReadHandler rootHandler, String uri, String tagName) {
        super.init(rootHandler, uri, tagName);
        Element element = this.getElement();
        element.setNamespace(uri);
        element.setType(tagName);
    }

    protected void startParsing(Attributes attrs) throws SAXException {
        super.startParsing(attrs);
        this.style = attrs.getValue("http://jfreereport.sourceforge.net/namespaces/reports/flow", "style");
        String enabledValue = attrs.getValue("http://jfreereport.sourceforge.net/namespaces/reports/flow", "enabled");
        this.enabled = enabledValue != null ? "true".equals(enabledValue) : true;
        String virtualValue = attrs.getValue("http://jfreereport.sourceforge.net/namespaces/reports/flow", "virtual");
        this.virtual = virtualValue != null ? "true".equals(virtualValue) : false;
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if ("http://jfreereport.sourceforge.net/namespaces/reports/flow".equals(uri)) {
            if ("expression".equals(tagName)) {
                ExpressionReadHandler erh = new ExpressionReadHandler();
                this.expressionHandlers.add(erh);
                return erh;
            }
            if ("style-expression".equals(tagName)) {
                StyleExpressionReadHandler erh = new StyleExpressionReadHandler();
                this.styleExpressionHandlers.add(erh);
                return erh;
            }
            if ("style-property".equals(tagName)) {
                PropertyReadHandler erh = new PropertyReadHandler();
                this.stylePropertyHandlers.add(erh);
                return erh;
            }
            if ("attribute-expression".equals(tagName)) {
                AttributeExpressionReadHandler erh = new AttributeExpressionReadHandler();
                this.attributeExpressionHandlers.add(erh);
                return erh;
            }
            if ("attribute".equals(tagName)) {
                AttributeReadHandler erh = new AttributeReadHandler();
                this.attributeHandlers.add(erh);
                return erh;
            }
            if ("display-condition".equals(tagName)) {
                this.displayConditionReadHandler = new DisplayConditionReadHandler();
                return this.displayConditionReadHandler;
            }
        }
        return null;
    }

    protected void configureElement(Element e) {
        Object handler;
        int i;
        if (this.displayConditionReadHandler != null) {
            e.setDisplayCondition(this.displayConditionReadHandler.getExpression());
        }
        for (i = 0; i < this.expressionHandlers.size(); ++i) {
            handler = (ExpressionReadHandler)((Object)this.expressionHandlers.get(i));
            e.addExpression(((AbstractExpressionReadHandler)((Object)handler)).getExpression());
        }
        for (i = 0; i < this.styleExpressionHandlers.size(); ++i) {
            handler = (StyleExpressionReadHandler)((Object)this.styleExpressionHandlers.get(i));
            e.setStyleExpression(((StyleExpressionReadHandler)((Object)handler)).getStyleKey(), ((AbstractExpressionReadHandler)((Object)handler)).getExpression());
        }
        for (i = 0; i < this.stylePropertyHandlers.size(); ++i) {
            handler = (PropertyReadHandler)this.stylePropertyHandlers.get(i);
            e.getStyle().setPropertyValueAsString(handler.getName(), handler.getResult());
        }
        for (i = 0; i < this.attributeExpressionHandlers.size(); ++i) {
            handler = (AttributeExpressionReadHandler)((Object)this.attributeExpressionHandlers.get(i));
            e.setAttributeExpression(((AttributeExpressionReadHandler)((Object)handler)).getAttributeName(), ((AbstractExpressionReadHandler)((Object)handler)).getExpression());
        }
        for (i = 0; i < this.attributeHandlers.size(); ++i) {
            handler = (AttributeReadHandler)((Object)this.attributeHandlers.get(i));
            e.setAttribute(((AttributeReadHandler)((Object)handler)).getNamespace(), handler.getName(), ((AttributeReadHandler)((Object)handler)).getObject());
        }
        e.setEnabled(this.enabled);
        e.setVirtual(this.virtual);
        if (this.style != null) {
            e.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/flow", "style", this.style);
        }
    }

    protected abstract Element getElement();

    public final Node getNode() {
        return this.getElement();
    }

    public Object getObject() throws SAXException {
        return this.getElement();
    }
}

