/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.factories.report.flow;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.jfree.report.JFreeReport;
import org.jfree.report.modules.factories.data.base.DataFactoryReadHandler;
import org.jfree.report.modules.factories.data.base.DataFactoryReadHandlerFactory;
import org.jfree.report.modules.factories.report.flow.SectionReadHandler;
import org.jfree.report.modules.factories.report.flow.StyleSheetReadHandler;
import org.jfree.report.structure.Element;
import org.jfree.xmlns.parser.ParseException;
import org.jfree.xmlns.parser.PropertiesReadHandler;
import org.jfree.xmlns.parser.StringReadHandler;
import org.jfree.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ReportReadHandler
extends SectionReadHandler {
    private StringReadHandler queryReadHandler;
    private PropertiesReadHandler propertiesReadHandler;
    private DataFactoryReadHandler datasourceFactoryReadHandler;
    private ArrayList styleSheetReadHandlers;
    private JFreeReport report = new JFreeReport();

    public ReportReadHandler() {
        this.styleSheetReadHandlers = new ArrayList();
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        XmlReadHandler base = super.getHandlerForChild(uri, tagName, atts);
        if (base != null) {
            return base;
        }
        DataFactoryReadHandlerFactory factory = DataFactoryReadHandlerFactory.getInstance();
        DataFactoryReadHandler handler = (DataFactoryReadHandler)factory.getHandler(uri, tagName);
        if (handler != null) {
            this.datasourceFactoryReadHandler = handler;
            return handler;
        }
        if ("http://jfreereport.sourceforge.net/namespaces/reports/flow".equals(uri)) {
            if ("query".equals(tagName)) {
                this.queryReadHandler = new StringReadHandler();
                return this.queryReadHandler;
            }
            if ("configuration".equals(tagName)) {
                this.propertiesReadHandler = new PropertiesReadHandler();
                return this.propertiesReadHandler;
            }
            if ("stylesheet".equals(tagName)) {
                StyleSheetReadHandler srh = new StyleSheetReadHandler();
                this.styleSheetReadHandlers.add(srh);
                return srh;
            }
            if ("inline-stylesheet".equals(tagName)) {
                StyleSheetReadHandler srh = new StyleSheetReadHandler();
                this.styleSheetReadHandlers.add(srh);
                return srh;
            }
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        if (this.queryReadHandler == null) {
            throw new ParseException("Required element 'query' is missing.", this.getLocator());
        }
        super.doneParsing();
        JFreeReport report = (JFreeReport)this.getElement();
        report.setQuery(this.queryReadHandler.getResult());
        if (this.propertiesReadHandler != null) {
            Properties p = this.propertiesReadHandler.getResult();
            Iterator<Map.Entry<Object, Object>> entries = p.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry<Object, Object> entry = entries.next();
                report.getEditableConfiguration().setConfigProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.datasourceFactoryReadHandler != null) {
            report.setDataFactory(this.datasourceFactoryReadHandler.getDataFactory());
        }
        for (int i = 0; i < this.styleSheetReadHandlers.size(); ++i) {
            StyleSheetReadHandler handler = (StyleSheetReadHandler)((Object)this.styleSheetReadHandlers.get(i));
            report.addStyleSheet(handler.getStyleSheet());
        }
    }

    protected Element getElement() {
        return this.report;
    }
}

