/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.swing.common;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.jfree.report.event.ReportProgressEvent;
import org.jfree.report.event.ReportProgressListener;

public class ReportProgressBar
extends JProgressBar {
    private MessageFormat pageMessageFormatter;
    private MessageFormat currentRowFormatter;
    private String layoutText;
    private String outputText;
    private ResourceBundle resources;

    public ReportProgressBar(Locale locale) {
        this.setLocale(locale);
        this.initialize();
    }

    public ReportProgressBar() {
        this.setLocale(Locale.getDefault());
        this.initialize();
    }

    private void initialize() {
        this.resources = ResourceBundle.getBundle("org.jfree.report.modules.gui.common.resources");
        this.pageMessageFormatter = new MessageFormat(this.resources.getString("progress-dialog.page-label"));
        this.currentRowFormatter = new MessageFormat(this.resources.getString("progress-dialog.current-row-label"));
    }

    private class ReportProgressHandler
    implements ReportProgressListener {
        public void reportProcessingStarted(ReportProgressEvent event) {
            this.postUpdate(event);
        }

        public void reportProcessingUpdate(ReportProgressEvent event) {
            this.postUpdate(event);
        }

        public void reportProcessingFinished(ReportProgressEvent event) {
            this.postUpdate(event);
        }

        private void postUpdate(ReportProgressEvent event) {
            ScreenUpdateRunnable runnable = new ScreenUpdateRunnable(event.getActivity(), event.getRow(), event.getPage());
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    private class ScreenUpdateRunnable
    implements Runnable {
        private int page;
        private int activity;
        private int currentRow;

        public ScreenUpdateRunnable(int activity, int currentRow, int page) {
            this.activity = activity;
            this.currentRow = currentRow;
            this.page = page;
        }

        public void run() {
            ReportProgressBar.this.setValue(this.currentRow);
        }
    }
}

