/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.swing.html;

import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.jfree.report.ReportConfigurationException;
import org.jfree.report.flow.ReportJob;
import org.jfree.report.modules.gui.swing.common.AbstractExportActionPlugin;
import org.jfree.report.modules.gui.swing.common.SwingGuiContext;
import org.jfree.report.modules.gui.swing.html.HtmlFileExportTask;
import org.jfree.util.ResourceBundleSupport;

public class HtmlFileExportActionPlugin
extends AbstractExportActionPlugin {
    private ResourceBundleSupport resources;
    private static final String EXPORT_DIALOG_KEY = "org.jfree.report.modules.gui.swing.html.file.ExportDialog";

    protected String getConfigurationPrefix() {
        return "org.jfree.report.modules.gui.swing.html.export.file.";
    }

    public boolean initialize(SwingGuiContext context) {
        super.initialize(context);
        this.resources = new ResourceBundleSupport(context.getLocale(), "org.jfree.report.modules.gui.swing.html.resources");
        return true;
    }

    public String getDisplayName() {
        return this.resources.getString("action.export-to-html.file.name");
    }

    public String getShortDescription() {
        return this.resources.getString("action.export-to-html.file.description");
    }

    public Icon getSmallIcon() {
        return null;
    }

    public Icon getLargeIcon() {
        return null;
    }

    public KeyStroke getAcceleratorKey() {
        return this.resources.getOptionalKeyStroke("action.export-to-html.file.accelerator");
    }

    public Integer getMnemonicKey() {
        return this.resources.getOptionalMnemonic("action.export-to-html.file.mnemonic");
    }

    public boolean performExport(ReportJob job) {
        if (!this.performShowExportDialog(job, EXPORT_DIALOG_KEY)) {
            return false;
        }
        try {
            HtmlFileExportTask task = new HtmlFileExportTask(job);
            Thread worker = new Thread(task);
            this.setStatusText("Started Job");
            worker.start();
            return true;
        }
        catch (ReportConfigurationException e) {
            this.setStatusText("Failed to configure the export task.");
            return false;
        }
    }
}

