/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.swing.html;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import org.jfree.io.IOUtils;
import org.jfree.report.flow.ReportJob;
import org.jfree.report.modules.gui.common.DefaultIconTheme;
import org.jfree.report.modules.gui.common.GuiContext;
import org.jfree.report.modules.gui.swing.common.AbstractExportDialog;
import org.jfree.report.modules.gui.swing.common.JStatusBar;
import org.jfree.report.modules.gui.swing.common.localization.JLabelLocaleUpdateHandler;
import org.jfree.ui.FilesystemFilter;
import org.jfree.ui.action.ActionButton;
import org.jfree.util.Configuration;
import org.jfree.util.DefaultConfiguration;
import org.jfree.util.StringUtils;

public class HtmlZipExportDialog
extends AbstractExportDialog {
    private static final String ZIP_FILE_EXTENSION = ".zip";
    private JTextField filenameField;
    private JFileChooser fileChooserHtml;
    private JTextField dataDirField;
    private JStatusBar statusBar;
    private JRadioButton rbPageableExport;
    private JRadioButton rbStreamExport;
    private JRadioButton rbFlowExport;

    public HtmlZipExportDialog() {
        this.initializeComponents();
    }

    public HtmlZipExportDialog(Frame owner) {
        super(owner);
        this.initializeComponents();
    }

    public HtmlZipExportDialog(Dialog owner) {
        super(owner);
        this.initializeComponents();
    }

    public String getFilename() {
        return this.filenameField.getText();
    }

    public void setFilename(String filename) {
        this.filenameField.setText(filename);
    }

    private void initializeComponents() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        this.filenameField = new JTextField();
        this.dataDirField = new JTextField();
        this.statusBar = new JStatusBar(new DefaultIconTheme());
        JLabel targetLabel = new JLabel();
        this.addPropertyChangeListener(new JLabelLocaleUpdateHandler(targetLabel, "org.jfree.report.modules.gui.swing.html.resources", "htmlexportdialog.filename"));
        JLabel dataLabel = new JLabel();
        this.addPropertyChangeListener(new JLabelLocaleUpdateHandler(dataLabel, "org.jfree.report.modules.gui.swing.html.resources", "htmlexportdialog.datafilename"));
        JLabel exportMethodLabel = new JLabel(this.getResources().getString("htmlexportdialog.exportMethod"));
        this.addPropertyChangeListener("locale", new JLabelLocaleUpdateHandler(exportMethodLabel, "org.jfree.report.modules.gui.swing.html.resources", "htmlexportdialog.exportMethod"));
        this.rbStreamExport = new JRadioButton(this.getResources().getString("htmlexportdialog.stream-export"));
        this.rbStreamExport.setSelected(true);
        this.rbFlowExport = new JRadioButton(this.getResources().getString("htmlexportdialog.flow-export"));
        this.rbPageableExport = new JRadioButton(this.getResources().getString("htmlexportdialog.pageable-export"));
        ButtonGroup bgExport = new ButtonGroup();
        bgExport.add(this.rbStreamExport);
        bgExport.add(this.rbFlowExport);
        bgExport.add(this.rbPageableExport);
        JPanel exportTypeSelectionPanel = new JPanel();
        exportTypeSelectionPanel.setLayout(new GridLayout(3, 1, 5, 5));
        exportTypeSelectionPanel.add(this.rbStreamExport);
        exportTypeSelectionPanel.add(this.rbFlowExport);
        exportTypeSelectionPanel.add(this.rbPageableExport);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(1, 1, 1, 5);
        contentPane.add((Component)targetLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(1, 1, 1, 5);
        contentPane.add((Component)dataLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)this.filenameField, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridx = 2;
        gbc.gridy = 0;
        ActionSelectTargetFile selectTargetAction = new ActionSelectTargetFile(this.getResources());
        contentPane.add((Component)new ActionButton((Action)selectTargetAction), gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)this.dataDirField, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 2;
        contentPane.add((Component)exportMethodLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)exportTypeSelectionPanel, gbc);
        ActionButton btnCancel = new ActionButton(this.getCancelAction());
        ActionButton btnConfirm = new ActionButton(this.getConfirmAction());
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout());
        buttonPanel.add((Component)btnConfirm);
        buttonPanel.add((Component)btnCancel);
        btnConfirm.setDefaultCapable(true);
        buttonPanel.registerKeyboardAction(this.getConfirmAction(), KeyStroke.getKeyStroke(10, 0), 1);
        gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 13;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridwidth = 3;
        gbc.gridy = 15;
        gbc.insets = new Insets(10, 0, 10, 0);
        contentPane.add((Component)buttonPanel, gbc);
        JPanel contentWithStatus = new JPanel();
        contentWithStatus.setLayout(new BorderLayout());
        contentWithStatus.add((Component)contentPane, "Center");
        contentWithStatus.add((Component)this.statusBar, "South");
        this.setContentPane(contentWithStatus);
        this.getFormValidator().registerTextField(this.dataDirField);
        this.getFormValidator().registerTextField(this.filenameField);
    }

    public JStatusBar getStatusBar() {
        return this.statusBar;
    }

    protected boolean performValidate() {
        this.getStatusBar().clear();
        String filename = this.getFilename();
        if (filename.trim().length() == 0) {
            this.getStatusBar().setStatus(3, this.getResources().getString("htmlexportdialog.targetIsEmpty"));
            return false;
        }
        File f = new File(filename);
        if (f.exists()) {
            if (!f.isFile()) {
                this.getStatusBar().setStatus(3, this.getResources().getString("htmlexportdialog.targetIsNoFile"));
                return false;
            }
            if (!f.canWrite()) {
                this.getStatusBar().setStatus(3, this.getResources().getString("htmlexportdialog.targetIsNotWritable"));
                return false;
            }
            String message = MessageFormat.format(this.getResources().getString("htmlexportdialog.targetExistsWarning"), filename);
            this.getStatusBar().setStatus(2, message);
        }
        try {
            File dataDir = new File(this.dataDirField.getText());
            File baseDir = new File("");
            if (!IOUtils.getInstance().isSubDirectory(baseDir, dataDir)) {
                this.getStatusBar().setStatus(3, this.getResources().getString("htmlexportdialog.targetPathIsAbsolute"));
                return false;
            }
        }
        catch (Exception e) {
            this.getStatusBar().setStatus(3, "error.validationfailed");
            return false;
        }
        return true;
    }

    protected boolean performConfirm() {
        String filename = this.getFilename();
        File f = new File(filename).getAbsoluteFile();
        if (f.exists()) {
            String key1 = "htmlexportdialog.targetOverwriteConfirmation";
            String key2 = "htmlexportdialog.targetOverwriteTitle";
            if (JOptionPane.showConfirmDialog(this, MessageFormat.format(this.getResources().getString("htmlexportdialog.targetOverwriteConfirmation"), this.getFilename()), this.getResources().getString("htmlexportdialog.targetOverwriteTitle"), 0, 3) == 1) {
                return false;
            }
        }
        return true;
    }

    protected void initializeFromJob(ReportJob job, GuiContext guiContext) {
        this.statusBar.setIconTheme(guiContext.getIconTheme());
    }

    protected String getConfigurationPrefix() {
        return "org.jfree.report.modules.gui.common.html.zip.";
    }

    protected Configuration grabDialogContents(boolean full) {
        DefaultConfiguration conf = new DefaultConfiguration();
        if (full) {
            conf.setConfigProperty("org.jfree.report.modules.gui.common.html.zip.TargetFileName", this.filenameField.getText());
            conf.setConfigProperty("org.jfree.report.modules.gui.common.html.zip.DataDirectory", this.dataDirField.getText());
        }
        conf.setConfigProperty("org.jfree.report.modules.gui.common.html.zip.ExportMethod", this.getExportMethod());
        return conf;
    }

    protected void setDialogContents(Configuration properties) {
        this.filenameField.setText(properties.getConfigProperty("org.jfree.report.modules.gui.common.html.zip.TargetFileName", ""));
        this.dataDirField.setText(properties.getConfigProperty("org.jfree.report.modules.gui.common.html.zip.DataDirectory", ""));
        this.setExportMethod(properties.getConfigProperty("org.jfree.report.modules.gui.common.html.zip.ExportMethod", ""));
    }

    protected String getConfigurationSuffix() {
        return "_htmlexport_file";
    }

    public String getExportMethod() {
        if (this.rbPageableExport.isSelected()) {
            return "pageable";
        }
        if (this.rbFlowExport.isSelected()) {
            return "flow";
        }
        return "stream";
    }

    public void setExportMethod(String method) {
        if ("pageable".equals(method)) {
            this.rbPageableExport.setSelected(true);
        } else if ("flow".equals(method)) {
            this.rbFlowExport.setSelected(true);
        } else {
            this.rbStreamExport.setSelected(true);
        }
    }

    public void clear() {
        this.filenameField.setText("");
        this.dataDirField.setText("");
        this.rbStreamExport.setSelected(true);
    }

    protected String getResourceBaseName() {
        return "org.jfree.report.modules.gui.swing.html.resources";
    }

    protected void performSelectFile() {
        File file = new File(this.getFilename());
        if (this.fileChooserHtml == null) {
            this.fileChooserHtml = new JFileChooser();
            this.fileChooserHtml.addChoosableFileFilter((FileFilter)new FilesystemFilter(new String[]{ZIP_FILE_EXTENSION}, this.getResources().getString("htmlexportdialog.zip-archives"), true));
            this.fileChooserHtml.setMultiSelectionEnabled(false);
        }
        this.fileChooserHtml.setCurrentDirectory(file);
        this.fileChooserHtml.setSelectedFile(file);
        int option = this.fileChooserHtml.showSaveDialog(this);
        if (option == 0) {
            File selFile = this.fileChooserHtml.getSelectedFile();
            String selFileName = selFile.getAbsolutePath();
            if (!StringUtils.endsWithIgnoreCase((String)selFileName, (String)ZIP_FILE_EXTENSION)) {
                selFileName = selFileName + ZIP_FILE_EXTENSION;
            }
            this.setFilename(selFileName);
        }
    }

    private class ActionSelectTargetFile
    extends AbstractAction {
        public ActionSelectTargetFile(ResourceBundle resources) {
            this.putValue("Name", resources.getString("htmlexportdialog.select"));
        }

        public void actionPerformed(ActionEvent e) {
            HtmlZipExportDialog.this.performSelectFile();
        }
    }
}

