/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.swing.pdf;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import org.jfree.fonts.encoding.EncodingRegistry;
import org.jfree.report.flow.ReportJob;
import org.jfree.report.modules.gui.common.GuiContext;
import org.jfree.report.modules.gui.swing.common.AbstractExportDialog;
import org.jfree.report.modules.gui.swing.common.EncodingComboBoxModel;
import org.jfree.report.modules.gui.swing.common.JStatusBar;
import org.jfree.ui.FilesystemFilter;
import org.jfree.ui.action.ActionButton;
import org.jfree.util.Configuration;
import org.jfree.util.DefaultConfiguration;
import org.jfree.util.Log;

public class PdfExportDialog
extends AbstractExportDialog {
    private static final int CBMODEL_NOPRINTING = 0;
    private static final int CBMODEL_DEGRADED = 1;
    private static final int CBMODEL_FULL = 2;
    private JRadioButton rbSecurityNone;
    private JRadioButton rbSecurity40Bit;
    private JRadioButton rbSecurity128Bit;
    private JTextField txUserPassword;
    private JTextField txOwnerPassword;
    private JTextField txConfUserPassword;
    private JTextField txConfOwnerPassword;
    private JCheckBox cxAllowCopy;
    private JCheckBox cxAllowScreenReaders;
    private JComboBox cbAllowPrinting;
    private JCheckBox cxAllowAssembly;
    private JCheckBox cxAllowModifyContents;
    private JCheckBox cxAllowModifyAnnotations;
    private JCheckBox cxAllowFillIn;
    private EncodingComboBoxModel encodingModel;
    private JFileChooser fileChooser;
    private static final String PDF_FILE_EXTENSION = ".pdf";
    private JStatusBar statusBar;
    private JTextField txFilename;
    private DefaultComboBoxModel printingModel;

    public PdfExportDialog() {
        this.initializeComponents();
    }

    public PdfExportDialog(Frame owner) {
        super(owner);
        this.initializeComponents();
    }

    public PdfExportDialog(Dialog owner) {
        super(owner);
        this.initializeComponents();
    }

    private void initializeComponents() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JLabel lblFileName = new JLabel(this.getResources().getString("pdfsavedialog.filename"));
        JLabel lblEncoding = new JLabel(this.getResources().getString("pdfsavedialog.encoding"));
        ActionButton btnSelect = new ActionButton((Action)new ActionSelectFile(this.getResources()));
        this.txFilename = new JTextField();
        this.statusBar = new JStatusBar();
        this.encodingModel = EncodingComboBoxModel.createDefaultModel(Locale.getDefault());
        this.encodingModel.addEncodingUnchecked("Identity-H", "PDF-Unicode encoding");
        this.encodingModel.addEncodingUnchecked("Identity-V", "PDF-Unicode encoding");
        this.encodingModel.sort();
        JComboBox cbEncoding = new JComboBox(this.encodingModel);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 1, 1, 1);
        mainPanel.add((Component)lblFileName, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.ipadx = 120;
        gbc.insets = new Insets(3, 1, 1, 1);
        mainPanel.add((Component)this.txFilename, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridx = 2;
        gbc.gridy = 0;
        mainPanel.add((Component)btnSelect, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(1, 1, 1, 1);
        mainPanel.add((Component)lblEncoding, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.ipadx = 120;
        gbc.insets = new Insets(1, 1, 1, 1);
        mainPanel.add(cbEncoding, gbc);
        ActionButton btnCancel = new ActionButton(this.getCancelAction());
        ActionButton btnConfirm = new ActionButton(this.getConfirmAction());
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2, 5, 5));
        buttonPanel.add((Component)btnConfirm);
        buttonPanel.add((Component)btnCancel);
        btnConfirm.setDefaultCapable(true);
        this.getRootPane().setDefaultButton((JButton)btnConfirm);
        buttonPanel.registerKeyboardAction(this.getConfirmAction(), KeyStroke.getKeyStroke(10, 0), 1);
        JPanel buttonCarrier = new JPanel();
        buttonCarrier.setLayout(new FlowLayout(2));
        buttonCarrier.add(buttonPanel);
        gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 13;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridwidth = 3;
        gbc.gridy = 6;
        gbc.insets = new Insets(10, 0, 0, 0);
        JPanel mainPaneCarrier = new JPanel();
        mainPaneCarrier.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        mainPaneCarrier.setLayout(new BorderLayout());
        mainPaneCarrier.add((Component)mainPanel, "North");
        JPanel securityPaneCarrier = new JPanel();
        securityPaneCarrier.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        securityPaneCarrier.setLayout(new BorderLayout());
        securityPaneCarrier.add((Component)this.createSecurityPanel(), "North");
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add("Export-Settings", mainPaneCarrier);
        tabbedPane.add("Security", securityPaneCarrier);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)tabbedPane, "Center");
        contentPane.add((Component)buttonCarrier, "South");
        JPanel contentWithStatus = new JPanel();
        contentWithStatus.setLayout(new BorderLayout());
        contentWithStatus.add((Component)contentPane, "Center");
        contentWithStatus.add((Component)this.getStatusBar(), "South");
        this.setContentPane(contentWithStatus);
        this.getFormValidator().registerTextField(this.txFilename);
        this.getFormValidator().registerTextField(this.txConfOwnerPassword);
        this.getFormValidator().registerTextField(this.txConfUserPassword);
        this.getFormValidator().registerTextField(this.txUserPassword);
        this.getFormValidator().registerTextField(this.txOwnerPassword);
    }

    public JStatusBar getStatusBar() {
        return this.statusBar;
    }

    protected boolean performConfirm() {
        String filename = this.txFilename.getText();
        File f = new File(filename);
        if (f.exists()) {
            String key1 = "pdfsavedialog.targetOverwriteConfirmation";
            String key2 = "pdfsavedialog.targetOverwriteTitle";
            if (JOptionPane.showConfirmDialog(this, MessageFormat.format(this.getResources().getString("pdfsavedialog.targetOverwriteConfirmation"), this.txFilename.getText()), this.getResources().getString("pdfsavedialog.targetOverwriteTitle"), 0, 3) == 1) {
                return false;
            }
        }
        return !this.getEncryptionValue().equals("128bit") && !this.getEncryptionValue().equals("40bit") || this.txOwnerPassword.getText().trim().length() != 0 || JOptionPane.showConfirmDialog(this, this.getResources().getString("pdfsavedialog.ownerpasswordEmpty"), this.getResources().getString("pdfsavedialog.warningTitle"), 0, 2) != 1;
    }

    protected boolean performValidate() {
        this.getStatusBar().clear();
        String filename = this.txFilename.getText();
        if (filename.trim().length() == 0) {
            this.getStatusBar().setStatus(3, this.getResources().getString("pdfsavedialog.targetIsEmpty"));
            return false;
        }
        File f = new File(filename);
        if (f.exists()) {
            if (!f.isFile()) {
                this.getStatusBar().setStatus(3, this.getResources().getString("pdfsavedialog.targetIsNoFile"));
                return false;
            }
            if (!f.canWrite()) {
                this.getStatusBar().setStatus(3, this.getResources().getString("pdfsavedialog.targetIsNotWritable"));
                return false;
            }
            String message = MessageFormat.format(this.getResources().getString("pdfsavedialog.targetOverwriteWarning"), filename);
            this.getStatusBar().setStatus(2, message);
        }
        if (this.getEncryptionValue().equals("128bit") || this.getEncryptionValue().equals("40bit")) {
            if (!this.txUserPassword.getText().equals(this.txConfUserPassword.getText())) {
                this.getStatusBar().setStatus(3, this.getResources().getString("pdfsavedialog.userpasswordNoMatch"));
                return false;
            }
            if (!this.txOwnerPassword.getText().equals(this.txConfOwnerPassword.getText())) {
                this.getStatusBar().setStatus(3, this.getResources().getString("pdfsavedialog.ownerpasswordNoMatch"));
                return false;
            }
        }
        return true;
    }

    protected void initializeFromJob(ReportJob job, GuiContext guiContext) {
        this.statusBar.setIconTheme(guiContext.getIconTheme());
    }

    protected String getConfigurationPrefix() {
        return "org.jfree.report.modules.gui.common.pdf.";
    }

    protected Configuration grabDialogContents(boolean full) {
        DefaultConfiguration config = new DefaultConfiguration();
        String prefix = this.getConfigurationPrefix();
        config.setConfigProperty(prefix + "TargetFileName", this.txFilename.getText());
        config.setConfigProperty(prefix + "Encoding", this.encodingModel.getSelectedEncoding());
        config.getConfigProperty(prefix + "security.PrintLevel", this.getPrintLevel());
        config.getConfigProperty(prefix + "security.Encryption", this.getEncryptionValue());
        config.getConfigProperty(prefix + "security.UserPassword", this.txUserPassword.getText());
        config.getConfigProperty(prefix + "security.OwnerPassword", this.txOwnerPassword.getText());
        config.setConfigProperty(prefix + "security.AllowAssembly", String.valueOf(this.cxAllowAssembly.isSelected()));
        config.setConfigProperty(prefix + "security.AllowCopy", String.valueOf(this.cxAllowCopy.isSelected()));
        config.setConfigProperty(prefix + "security.AllowFillIn", String.valueOf(this.cxAllowFillIn.isSelected()));
        config.setConfigProperty(prefix + "security.AllowModifyAnnotations", String.valueOf(this.cxAllowModifyAnnotations.isSelected()));
        config.setConfigProperty(prefix + "security.AllowModifyContents", String.valueOf(this.cxAllowModifyContents.isSelected()));
        config.setConfigProperty(prefix + "security.AllowScreenReaders", String.valueOf(this.cxAllowScreenReaders.isSelected()));
        return config;
    }

    protected void setDialogContents(Configuration config) {
        String prefix = this.getConfigurationPrefix();
        this.txFilename.setText(config.getConfigProperty(prefix + "TargetFileName"));
        String encoding = config.getConfigProperty(prefix + "Encoding");
        if (encoding != null && encoding.length() > 0) {
            this.encodingModel.setSelectedEncoding(encoding);
        }
        this.setPrintLevel(config.getConfigProperty(prefix + "security.PrintLevel"));
        this.setEncryptionValue(config.getConfigProperty(prefix + "security.Encryption"));
        this.txUserPassword.setText(config.getConfigProperty(prefix + "security.UserPassword"));
        this.txOwnerPassword.setText(config.getConfigProperty(prefix + "security.OwnerPassword"));
        this.txConfUserPassword.setText(config.getConfigProperty(prefix + "security.UserPassword"));
        this.txConfOwnerPassword.setText(config.getConfigProperty(prefix + "security.OwnerPassword"));
        this.cxAllowAssembly.setSelected("true".equals(config.getConfigProperty(prefix + "security.AllowAssembly")));
        this.cxAllowCopy.setSelected("true".equals(config.getConfigProperty(prefix + "security.AllowCopy")));
        this.cxAllowFillIn.setSelected("true".equals(config.getConfigProperty(prefix + "security.AllowFillIn")));
        this.cxAllowModifyAnnotations.setSelected("true".equals(config.getConfigProperty(prefix + "security.AllowModifyAnnotations")));
        this.cxAllowModifyContents.setSelected("true".equals(config.getConfigProperty(prefix + "security.AllowModifyContents")));
        this.cxAllowScreenReaders.setSelected("true".equals(config.getConfigProperty(prefix + "security.AllowScreenReaders")));
    }

    protected String getConfigurationSuffix() {
        return "_pdf_export";
    }

    public void clear() {
        this.txConfOwnerPassword.setText("");
        this.txConfUserPassword.setText("");
        this.txFilename.setText("");
        this.txOwnerPassword.setText("");
        this.txUserPassword.setText("");
        this.cxAllowAssembly.setSelected(false);
        this.cxAllowCopy.setSelected(false);
        this.cbAllowPrinting.setSelectedIndex(0);
        this.cxAllowFillIn.setSelected(false);
        this.cxAllowModifyAnnotations.setSelected(false);
        this.cxAllowModifyContents.setSelected(false);
        this.cxAllowScreenReaders.setSelected(false);
        this.rbSecurityNone.setSelected(true);
        this.updateSecurityPanelEnabled();
        String plattformDefaultEncoding = EncodingRegistry.getPlattformDefaultEncoding();
        this.encodingModel.setSelectedEncoding(plattformDefaultEncoding);
    }

    protected String getResourceBaseName() {
        return "org.jfree.report.modules.gui.swing.pdf.resources";
    }

    protected void updateSecurityPanelEnabled() {
        boolean b = !this.rbSecurityNone.isSelected();
        this.txUserPassword.setEnabled(b);
        this.txOwnerPassword.setEnabled(b);
        this.txConfOwnerPassword.setEnabled(b);
        this.txConfUserPassword.setEnabled(b);
        this.cxAllowAssembly.setEnabled(b);
        this.cxAllowCopy.setEnabled(b);
        this.cbAllowPrinting.setEnabled(b);
        this.cxAllowFillIn.setEnabled(b);
        this.cxAllowModifyAnnotations.setEnabled(b);
        this.cxAllowModifyContents.setEnabled(b);
        this.cxAllowScreenReaders.setEnabled(b);
    }

    private void createSecurityPanelComponents() {
        this.txUserPassword = new JPasswordField();
        this.txConfUserPassword = new JPasswordField();
        this.txOwnerPassword = new JPasswordField();
        this.txConfOwnerPassword = new JPasswordField();
        this.cxAllowCopy = new JCheckBox(this.getResources().getString("pdfsavedialog.allowCopy"));
        this.cbAllowPrinting = new JComboBox(this.getPrintingComboBoxModel());
        this.cxAllowScreenReaders = new JCheckBox(this.getResources().getString("pdfsavedialog.allowScreenreader"));
        this.cxAllowAssembly = new JCheckBox(this.getResources().getString("pdfsavedialog.allowAssembly"));
        this.cxAllowModifyContents = new JCheckBox(this.getResources().getString("pdfsavedialog.allowModifyContents"));
        this.cxAllowModifyAnnotations = new JCheckBox(this.getResources().getString("pdfsavedialog.allowModifyAnnotations"));
        this.cxAllowFillIn = new JCheckBox(this.getResources().getString("pdfsavedialog.allowFillIn"));
    }

    private JPanel createSecurityPanel() {
        JPanel securityPanel = new JPanel();
        securityPanel.setLayout(new GridBagLayout());
        this.createSecurityPanelComponents();
        JLabel lblUserPass = new JLabel(this.getResources().getString("pdfsavedialog.userpassword"));
        JLabel lblUserPassConfirm = new JLabel(this.getResources().getString("pdfsavedialog.userpasswordconfirm"));
        JLabel lblOwnerPass = new JLabel(this.getResources().getString("pdfsavedialog.ownerpassword"));
        JLabel lblOwnerPassConfirm = new JLabel(this.getResources().getString("pdfsavedialog.ownerpasswordconfirm"));
        JLabel lbAllowPrinting = new JLabel(this.getResources().getString("pdfsavedialog.allowPrinting"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridwidth = 4;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        securityPanel.add((Component)this.createSecurityConfigPanel(), gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        securityPanel.add((Component)lblUserPass, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.ipadx = 120;
        gbc.insets = new Insets(5, 5, 5, 5);
        securityPanel.add((Component)this.txUserPassword, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        securityPanel.add((Component)lblOwnerPass, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.ipadx = 120;
        gbc.insets = new Insets(5, 5, 5, 5);
        securityPanel.add((Component)this.txOwnerPassword, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        securityPanel.add((Component)lblUserPassConfirm, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.ipadx = 120;
        gbc.insets = new Insets(5, 5, 5, 5);
        securityPanel.add((Component)this.txConfUserPassword, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        securityPanel.add((Component)lblOwnerPassConfirm, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 3;
        gbc.gridy = 2;
        gbc.ipadx = 120;
        gbc.insets = new Insets(5, 5, 5, 5);
        securityPanel.add((Component)this.txConfOwnerPassword, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.gridy = 3;
        gbc.anchor = 17;
        securityPanel.add((Component)this.cxAllowCopy, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.gridy = 4;
        gbc.anchor = 17;
        securityPanel.add((Component)this.cxAllowScreenReaders, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.gridy = 5;
        gbc.anchor = 17;
        securityPanel.add((Component)this.cxAllowFillIn, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridwidth = 2;
        gbc.gridy = 3;
        gbc.anchor = 17;
        securityPanel.add((Component)this.cxAllowAssembly, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridwidth = 2;
        gbc.gridy = 4;
        gbc.anchor = 17;
        securityPanel.add((Component)this.cxAllowModifyContents, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridwidth = 2;
        gbc.gridy = 5;
        gbc.anchor = 17;
        securityPanel.add((Component)this.cxAllowModifyAnnotations, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.gridy = 6;
        gbc.anchor = 17;
        securityPanel.add((Component)lbAllowPrinting, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridwidth = 3;
        gbc.gridy = 6;
        gbc.anchor = 17;
        securityPanel.add((Component)this.cbAllowPrinting, gbc);
        return securityPanel;
    }

    private JPanel createSecurityConfigPanel() {
        this.rbSecurityNone = new JRadioButton(this.getResources().getString("pdfsavedialog.securityNone"));
        this.rbSecurity40Bit = new JRadioButton(this.getResources().getString("pdfsavedialog.security40bit"));
        this.rbSecurity128Bit = new JRadioButton(this.getResources().getString("pdfsavedialog.security128bit"));
        ActionSecuritySelection securitySelectAction = new ActionSecuritySelection();
        this.rbSecurityNone.addActionListener(securitySelectAction);
        this.rbSecurity40Bit.addActionListener(securitySelectAction);
        this.rbSecurity128Bit.addActionListener(securitySelectAction);
        this.rbSecurity128Bit.setSelected(true);
        JPanel pnlSecurityConfig = new JPanel();
        pnlSecurityConfig.setLayout(new GridLayout());
        pnlSecurityConfig.add(this.rbSecurityNone);
        pnlSecurityConfig.add(this.rbSecurity40Bit);
        pnlSecurityConfig.add(this.rbSecurity128Bit);
        ButtonGroup btGrpSecurity = new ButtonGroup();
        btGrpSecurity.add(this.rbSecurity128Bit);
        btGrpSecurity.add(this.rbSecurity40Bit);
        btGrpSecurity.add(this.rbSecurityNone);
        return pnlSecurityConfig;
    }

    private DefaultComboBoxModel getPrintingComboBoxModel() {
        if (this.printingModel == null) {
            Object[] data = new Object[]{this.getResources().getString("pdfsavedialog.option.noprinting"), this.getResources().getString("pdfsavedialog.option.degradedprinting"), this.getResources().getString("pdfsavedialog.option.fullprinting")};
            this.printingModel = new DefaultComboBoxModel<Object>(data);
        }
        return this.printingModel;
    }

    protected void performSelectFile() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            FilesystemFilter filter = new FilesystemFilter(PDF_FILE_EXTENSION, "PDF Documents");
            this.fileChooser.addChoosableFileFilter((FileFilter)filter);
            this.fileChooser.setMultiSelectionEnabled(false);
        }
        File file = new File(this.txFilename.getText());
        this.fileChooser.setCurrentDirectory(file);
        this.fileChooser.setSelectedFile(file);
        int option = this.fileChooser.showSaveDialog(this);
        if (option == 0) {
            File selFile = this.fileChooser.getSelectedFile();
            String selFileName = selFile.getAbsolutePath();
            if (!selFileName.toLowerCase().endsWith(PDF_FILE_EXTENSION)) {
                selFileName = selFileName + PDF_FILE_EXTENSION;
            }
            this.txFilename.setText(selFileName);
        }
    }

    public void setPrintLevel(String printLevel) {
        if ("full".equals(printLevel)) {
            this.cbAllowPrinting.setSelectedIndex(2);
        } else if ("degraded".equals(printLevel)) {
            this.cbAllowPrinting.setSelectedIndex(1);
        } else {
            this.cbAllowPrinting.setSelectedIndex(0);
        }
    }

    public String getPrintLevel() {
        if (this.cbAllowPrinting.getSelectedIndex() == 2) {
            return "full";
        }
        if (this.cbAllowPrinting.getSelectedIndex() == 1) {
            return "degraded";
        }
        return "none";
    }

    public String getEncryptionValue() {
        if (this.rbSecurity40Bit.isSelected()) {
            return "40bit";
        }
        if (this.rbSecurity128Bit.isSelected()) {
            return "128bit";
        }
        return "none";
    }

    public void setEncryptionValue(String b) {
        if (b != null) {
            if (b.equals("128bit")) {
                this.rbSecurity128Bit.setSelected(true);
                this.updateSecurityPanelEnabled();
                return;
            }
            if (b.equals("40bit")) {
                this.rbSecurity40Bit.setSelected(true);
                this.updateSecurityPanelEnabled();
                return;
            }
            if (!b.equals("none")) {
                Log.warn((Object)("Invalid encryption value entered. " + b));
            }
        }
        this.rbSecurityNone.setSelected(true);
        this.updateSecurityPanelEnabled();
    }

    private class ActionSelectFile
    extends AbstractAction {
        protected ActionSelectFile(ResourceBundle resources) {
            this.putValue("Name", resources.getString("pdfsavedialog.selectFile"));
        }

        public void actionPerformed(ActionEvent e) {
            PdfExportDialog.this.performSelectFile();
        }
    }

    private class ActionSecuritySelection
    extends AbstractAction {
        protected ActionSecuritySelection() {
        }

        public void actionPerformed(ActionEvent e) {
            PdfExportDialog.this.updateSecurityPanelEnabled();
        }
    }
}

