/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.swing.pdf;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.jfree.base.config.ModifiableConfiguration;
import org.jfree.layouting.modules.output.pdf.PdfOutputProcessor;
import org.jfree.layouting.output.OutputProcessor;
import org.jfree.report.ReportConfigurationException;
import org.jfree.report.flow.ReportJob;
import org.jfree.report.flow.streaming.StreamingReportProcessor;
import org.jfree.util.Configuration;
import org.jfree.util.Log;

public class PdfExportTask
implements Runnable {
    private ReportJob job;
    private File targetFile;

    public PdfExportTask(ReportJob job) throws ReportConfigurationException {
        if (job == null) {
            throw new NullPointerException();
        }
        this.job = job;
        ModifiableConfiguration config = job.getConfiguration();
        String targetFileName = config.getConfigProperty("org.jfree.report.modules.gui.common.pdf.TargetFileName");
        this.targetFile = new File(targetFileName);
        if (this.targetFile.exists() && this.targetFile.delete()) {
            throw new ReportConfigurationException("Target-File exists, but cannot be removed.");
        }
    }

    public void run() {
        try {
            FileOutputStream fout = new FileOutputStream(this.targetFile);
            StreamingReportProcessor sp = new StreamingReportProcessor();
            PdfOutputProcessor outputProcessor = new PdfOutputProcessor((Configuration)this.job.getConfiguration(), (OutputStream)fout);
            sp.setOutputProcessor((OutputProcessor)outputProcessor);
            sp.processReport(this.job);
        }
        catch (Exception e) {
            Log.error((Object)"PDF-Export failed. ", (Exception)e);
        }
        try {
            this.job.close();
            this.job = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

