/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.swing.preview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import org.jfree.report.flow.ReportJob;
import org.jfree.report.modules.gui.common.IconTheme;
import org.jfree.report.modules.gui.swing.common.JStatusBar;
import org.jfree.report.modules.gui.swing.common.ReportProgressBar;
import org.jfree.report.modules.gui.swing.preview.PreviewPane;
import org.jfree.report.modules.gui.swing.preview.ReportController;

public class PreviewDialog
extends JDialog {
    private PreviewPane previewPane;
    private JStatusBar statusBar;
    private ReportProgressBar progressBar;
    private JLabel pageLabel;

    public PreviewDialog() {
        this.init();
    }

    public PreviewDialog(Frame owner) {
        super(owner);
        this.init();
    }

    public PreviewDialog(Frame owner, boolean modal) {
        super(owner, modal);
        this.init();
    }

    public PreviewDialog(Dialog owner) {
        super(owner);
        this.init();
    }

    public PreviewDialog(Dialog owner, boolean modal) {
        super(owner, modal);
        this.init();
    }

    protected void init() {
        this.previewPane = new PreviewPane();
        this.statusBar = new JStatusBar(this.previewPane.getIconTheme());
        this.progressBar = new ReportProgressBar();
        this.progressBar.setVisible(false);
        this.pageLabel = new JLabel();
        this.previewPane.addPropertyChangeListener(new PreviewPanePropertyChangeHandler());
        JComponent extensionArea = this.statusBar.getExtensionArea();
        extensionArea.setLayout(new BoxLayout(extensionArea, 0));
        extensionArea.add(this.progressBar);
        extensionArea.add(this.pageLabel);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.previewPane, "Center");
        contentPane.add((Component)this.statusBar, "South");
        this.setContentPane(contentPane);
    }

    public ReportController getReportController() {
        return this.previewPane.getReportController();
    }

    public void setReportController(ReportController reportController) {
        this.previewPane.setReportController(reportController);
    }

    public IconTheme getIconTheme() {
        return this.previewPane.getIconTheme();
    }

    public void setIconTheme(IconTheme theme) {
        this.previewPane.setIconTheme(theme);
    }

    public ReportJob getReportJob() {
        return this.previewPane.getReportJob();
    }

    public void setReportJob(ReportJob reportJob) {
        this.previewPane.setReportJob(reportJob);
    }

    private class PreviewPanePropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("menu".equals(propertyName)) {
                JMenu[] menus = PreviewDialog.this.previewPane.getMenu();
                if (menus != null && menus.length > 0) {
                    JMenuBar menuBar = new JMenuBar();
                    for (int i = 0; i < menus.length; ++i) {
                        JMenu menu = menus[i];
                        menuBar.add(menu);
                    }
                    PreviewDialog.this.setJMenuBar(menuBar);
                } else {
                    PreviewDialog.this.setJMenuBar(null);
                }
                return;
            }
            if ("title".equals(propertyName)) {
                PreviewDialog.this.setTitle(PreviewDialog.this.previewPane.getTitle());
                return;
            }
            if ("statusText".equals(propertyName) || "statusType".equals(propertyName)) {
                PreviewDialog.this.statusBar.setStatus(PreviewDialog.this.previewPane.getStatusType(), PreviewDialog.this.previewPane.getStatusText());
                return;
            }
            if ("iconTheme".equals(propertyName)) {
                PreviewDialog.this.statusBar.setIconTheme(PreviewDialog.this.previewPane.getIconTheme());
                return;
            }
            if ("paginating".equals(propertyName)) {
                if (Boolean.TRUE.equals(evt.getNewValue())) {
                    PreviewDialog.this.progressBar.setVisible(true);
                    PreviewDialog.this.pageLabel.setVisible(false);
                    PreviewDialog.this.statusBar.setStatus(1, "Paginating ...");
                } else {
                    PreviewDialog.this.progressBar.setVisible(false);
                    PreviewDialog.this.pageLabel.setVisible(true);
                    PreviewDialog.this.statusBar.setStatus(0, "");
                }
                PreviewDialog.this.progressBar.revalidate();
                return;
            }
            if ("pageNumber".equals(propertyName) || "numberOfPages".equals(propertyName)) {
                PreviewDialog.this.pageLabel.setText(PreviewDialog.this.previewPane.getPageNumber() + "/" + PreviewDialog.this.previewPane.getNumberOfPages());
                return;
            }
            if ("closed".equals(propertyName)) {
                if (PreviewDialog.this.previewPane.isClosed()) {
                    PreviewDialog.this.setVisible(false);
                    PreviewDialog.this.dispose();
                } else {
                    PreviewDialog.this.setVisible(true);
                }
            }
        }
    }
}

