/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.swing.preview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import org.jfree.report.flow.ReportJob;
import org.jfree.report.modules.gui.common.IconTheme;
import org.jfree.report.modules.gui.swing.common.JStatusBar;
import org.jfree.report.modules.gui.swing.common.ReportProgressBar;
import org.jfree.report.modules.gui.swing.preview.PreviewPane;
import org.jfree.report.modules.gui.swing.preview.ReportController;

public class PreviewFrame
extends JFrame {
    private PreviewPane previewPane;
    private JStatusBar statusBar;
    private ReportProgressBar progressBar;
    private JLabel pageLabel;

    public PreviewFrame() {
        this.init();
    }

    protected void init() {
        this.previewPane = new PreviewPane();
        this.statusBar = new JStatusBar(this.previewPane.getIconTheme());
        this.progressBar = new ReportProgressBar();
        this.progressBar.setVisible(false);
        this.pageLabel = new JLabel();
        this.previewPane.addPropertyChangeListener(new PreviewPanePropertyChangeHandler());
        JComponent extensionArea = this.statusBar.getExtensionArea();
        extensionArea.setLayout(new BoxLayout(extensionArea, 0));
        extensionArea.add(this.progressBar);
        extensionArea.add(this.pageLabel);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.previewPane, "Center");
        contentPane.add((Component)this.statusBar, "South");
        this.setContentPane(contentPane);
    }

    public ReportController getReportController() {
        return this.previewPane.getReportController();
    }

    public void setReportController(ReportController reportController) {
        this.previewPane.setReportController(reportController);
    }

    public IconTheme getIconTheme() {
        return this.previewPane.getIconTheme();
    }

    public void setIconTheme(IconTheme theme) {
        this.previewPane.setIconTheme(theme);
    }

    public ReportJob getReportJob() {
        return this.previewPane.getReportJob();
    }

    public void setReportJob(ReportJob reportJob) {
        this.previewPane.setReportJob(reportJob);
    }

    private class PreviewPanePropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("menu".equals(propertyName)) {
                JMenu[] menus = PreviewFrame.this.previewPane.getMenu();
                if (menus != null && menus.length > 0) {
                    JMenuBar menuBar = new JMenuBar();
                    for (int i = 0; i < menus.length; ++i) {
                        JMenu menu = menus[i];
                        menuBar.add(menu);
                    }
                    PreviewFrame.this.setJMenuBar(menuBar);
                } else {
                    PreviewFrame.this.setJMenuBar(null);
                }
                return;
            }
            if ("title".equals(propertyName)) {
                PreviewFrame.this.setTitle(PreviewFrame.this.previewPane.getTitle());
                return;
            }
            if ("statusText".equals(propertyName) || "statusType".equals(propertyName)) {
                PreviewFrame.this.statusBar.setStatus(PreviewFrame.this.previewPane.getStatusType(), PreviewFrame.this.previewPane.getStatusText());
                return;
            }
            if ("iconTheme".equals(propertyName)) {
                PreviewFrame.this.statusBar.setIconTheme(PreviewFrame.this.previewPane.getIconTheme());
                return;
            }
            if ("paginating".equals(propertyName)) {
                if (Boolean.TRUE.equals(evt.getNewValue())) {
                    PreviewFrame.this.progressBar.setVisible(true);
                    PreviewFrame.this.pageLabel.setVisible(false);
                } else {
                    PreviewFrame.this.progressBar.setVisible(false);
                    PreviewFrame.this.pageLabel.setVisible(true);
                }
                PreviewFrame.this.progressBar.revalidate();
                return;
            }
            if ("pageNumber".equals(propertyName) || "numberOfPages".equals(propertyName)) {
                PreviewFrame.this.pageLabel.setText(PreviewFrame.this.previewPane.getPageNumber() + "/" + PreviewFrame.this.previewPane.getNumberOfPages());
                return;
            }
            if ("closed".equals(propertyName)) {
                if (PreviewFrame.this.previewPane.isClosed()) {
                    PreviewFrame.this.setVisible(false);
                    PreviewFrame.this.dispose();
                } else {
                    PreviewFrame.this.setVisible(true);
                }
            }
        }
    }
}

