/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.swing.preview.actions;

import java.awt.Window;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jfree.report.modules.gui.swing.common.AbstractActionPlugin;
import org.jfree.report.modules.gui.swing.common.SwingGuiContext;
import org.jfree.report.modules.gui.swing.preview.PreviewPane;
import org.jfree.report.modules.gui.swing.preview.actions.ControlActionPlugin;
import org.jfree.util.Log;
import org.jfree.util.ResourceBundleSupport;

public class ZoomCustomActionPlugin
extends AbstractActionPlugin
implements ControlActionPlugin {
    private ResourceBundleSupport resources;

    public boolean initialize(SwingGuiContext context) {
        super.initialize(context);
        this.resources = new ResourceBundleSupport(context.getLocale(), "org.jfree.report.modules.gui.swing.preview.resources");
        return true;
    }

    protected String getConfigurationPrefix() {
        return "org.jfree.report.modules.gui.swing.preview.zoom-custom.";
    }

    public String getDisplayName() {
        return this.resources.getString("action.zoomCustom.name");
    }

    public String getShortDescription() {
        return this.resources.getString("action.zoomCustom.description");
    }

    public Icon getSmallIcon() {
        Locale locale = this.getContext().getLocale();
        return this.getIconTheme().getSmallIcon(locale, "action.zoomCustom.small-icon");
    }

    public Icon getLargeIcon() {
        Locale locale = this.getContext().getLocale();
        return this.getIconTheme().getLargeIcon(locale, "action.zoomCustom.icon");
    }

    public KeyStroke getAcceleratorKey() {
        return this.resources.getOptionalKeyStroke("action.zoomCustom.accelerator");
    }

    public Integer getMnemonicKey() {
        return this.resources.getOptionalMnemonic("action.zoomCustom.mnemonic");
    }

    public boolean configure(PreviewPane reportPane) {
        Window window = SwingUtilities.windowForComponent(reportPane);
        String result = JOptionPane.showInputDialog(window, this.resources.getString("dialog.zoom.title"), this.resources.getString("dialog.zoom.message"), 2);
        if (result == null) {
            return false;
        }
        try {
            double zoom = Double.parseDouble(result);
            if (zoom > 0.0 && zoom <= 4000.0) {
                reportPane.setZoom(zoom / 100.0);
                return true;
            }
        }
        catch (Exception ex) {
            Log.info((Object)"ZoomAction: swallowed an exception");
        }
        return false;
    }
}

