/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.swing.preview.actions;

import java.util.Locale;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.jfree.report.modules.gui.swing.common.AbstractActionPlugin;
import org.jfree.report.modules.gui.swing.common.SwingGuiContext;
import org.jfree.report.modules.gui.swing.preview.PreviewPane;
import org.jfree.report.modules.gui.swing.preview.PreviewPaneUtilities;
import org.jfree.report.modules.gui.swing.preview.actions.ControlActionPlugin;
import org.jfree.util.ResourceBundleSupport;

public class ZoomInActionPlugin
extends AbstractActionPlugin
implements ControlActionPlugin {
    private ResourceBundleSupport resources;

    public boolean initialize(SwingGuiContext context) {
        super.initialize(context);
        this.resources = new ResourceBundleSupport(context.getLocale(), "org.jfree.report.modules.gui.swing.preview.resources");
        return true;
    }

    protected String getConfigurationPrefix() {
        return "org.jfree.report.modules.gui.swing.preview.zoom-in.";
    }

    public String getDisplayName() {
        return this.resources.getString("action.zoomIn.name");
    }

    public String getShortDescription() {
        return this.resources.getString("action.zoomIn.description");
    }

    public Icon getSmallIcon() {
        Locale locale = this.getContext().getLocale();
        return this.getIconTheme().getSmallIcon(locale, "action.zoomIn.small-icon");
    }

    public Icon getLargeIcon() {
        Locale locale = this.getContext().getLocale();
        return this.getIconTheme().getLargeIcon(locale, "action.zoomIn.icon");
    }

    public KeyStroke getAcceleratorKey() {
        return this.resources.getOptionalKeyStroke("action.zoomIn.accelerator");
    }

    public Integer getMnemonicKey() {
        return this.resources.getOptionalMnemonic("action.zoomIn.mnemonic");
    }

    public boolean configure(PreviewPane reportPane) {
        double nextZoomIn = PreviewPaneUtilities.getNextZoomIn(reportPane.getZoom(), reportPane.getZoomFactors());
        if (nextZoomIn == 0.0) {
            return false;
        }
        reportPane.setZoom(nextZoomIn);
        return true;
    }
}

