/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.swing.printing;

import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import org.jfree.base.config.ModifiableConfiguration;
import org.jfree.report.flow.ReportJob;
import org.jfree.report.modules.gui.swing.printing.PrintReportProcessor;
import org.jfree.util.Configuration;
import org.jfree.util.Log;

public class PrinterUtility {
    public static final String PRINTER_JOB_NAME_KEY = "org.jfree.report.modules.gui.common.print.JobName";
    public static final String NUMBER_COPIES_KEY = "org.jfree.report.modules.gui.common.print.NumberOfCopies";

    private PrinterUtility() {
    }

    public static void printDirectly(ReportJob report) throws PrinterException {
        ModifiableConfiguration reportConfiguration = report.getConfiguration();
        String jobName = reportConfiguration.getConfigProperty(PRINTER_JOB_NAME_KEY, "JFreeReport");
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setJobName(jobName);
        printerJob.setPageable(new PrintReportProcessor(report));
        printerJob.setCopies(PrinterUtility.getNumberOfCopies((Configuration)reportConfiguration));
        printerJob.print();
    }

    public static boolean print(ReportJob report) throws PrinterException {
        ModifiableConfiguration reportConfiguration = report.getConfiguration();
        String jobName = reportConfiguration.getConfigProperty(PRINTER_JOB_NAME_KEY, "JFreeReport");
        PrintReportProcessor document = new PrintReportProcessor(report);
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setJobName(jobName);
        printerJob.setPageable(document);
        printerJob.setCopies(PrinterUtility.getNumberOfCopies((Configuration)reportConfiguration));
        if (printerJob.printDialog()) {
            printerJob.print();
            return true;
        }
        return false;
    }

    public static int getNumberOfCopies(Configuration configuration) {
        try {
            return Math.max(1, Integer.parseInt(configuration.getConfigProperty(NUMBER_COPIES_KEY, "1")));
        }
        catch (Exception e) {
            Log.warn((Object)"PrintUtil: Number of copies declared for the report is invalid");
            return 1;
        }
    }
}

